'
' Server example using "F4SharedMemGet" by Stephan 'stevie' Soolsma
' This dll extracts ALL data from the SharedMemory from Falcon and also allows you to send this (UDP) to a client.
' Also the client can be used to read data.
'
' Everyone may use this for free ( Weehee ) - A notice however would be great!
' Stephan 'stevie' Soolsma
' Author of FalconLog - ssoolsma@gmail.com
' 
' Email me for questions and thoughts

Public Class Form1
    Inherits System.Windows.Forms.Form
    Private IPAddress As String

#Region " Windows "

    Public Sub New()
        MyBase.New()
        InitializeComponent()
    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    Private components As System.ComponentModel.IContainer

    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents tbServerIP As System.Windows.Forms.TextBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Button1 As System.Windows.Forms.Button
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents Timer1 As System.Windows.Forms.Timer
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.Label3 = New System.Windows.Forms.Label
        Me.Button1 = New System.Windows.Forms.Button
        Me.Label2 = New System.Windows.Forms.Label
        Me.Label1 = New System.Windows.Forms.Label
        Me.tbServerIP = New System.Windows.Forms.TextBox
        Me.Timer1 = New System.Windows.Forms.Timer(Me.components)
        Me.GroupBox2 = New System.Windows.Forms.GroupBox
        Me.TextBox1 = New System.Windows.Forms.TextBox
        Me.GroupBox1.SuspendLayout()
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.Add(Me.Label3)
        Me.GroupBox1.Controls.Add(Me.Button1)
        Me.GroupBox1.Controls.Add(Me.Label2)
        Me.GroupBox1.Controls.Add(Me.Label1)
        Me.GroupBox1.Controls.Add(Me.tbServerIP)
        Me.GroupBox1.Location = New System.Drawing.Point(4, 4)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(200, 120)
        Me.GroupBox1.TabIndex = 2
        Me.GroupBox1.TabStop = False
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(88, 92)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(40, 16)
        Me.Label3.TabIndex = 6
        Me.Label3.Text = "Done!"
        Me.Label3.Visible = False
        '
        'Button1
        '
        Me.Button1.Location = New System.Drawing.Point(136, 88)
        Me.Button1.Name = "Button1"
        Me.Button1.Size = New System.Drawing.Size(48, 23)
        Me.Button1.TabIndex = 5
        Me.Button1.Text = "Set"
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(16, 16)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(168, 32)
        Me.Label2.TabIndex = 4
        Me.Label2.Text = "Please enter the IP of the server you wish to connect to."
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(16, 60)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(56, 16)
        Me.Label1.TabIndex = 3
        Me.Label1.Text = "Server IP:"
        '
        'tbServerIP
        '
        Me.tbServerIP.Location = New System.Drawing.Point(80, 56)
        Me.tbServerIP.Name = "tbServerIP"
        Me.tbServerIP.Size = New System.Drawing.Size(104, 20)
        Me.tbServerIP.TabIndex = 2
        Me.tbServerIP.Text = "127.0.0.1"
        '
        'Timer1
        '
        Me.Timer1.Enabled = True
        Me.Timer1.Interval = 1000
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.TextBox1)
        Me.GroupBox2.Location = New System.Drawing.Point(4, 126)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(200, 90)
        Me.GroupBox2.TabIndex = 3
        Me.GroupBox2.TabStop = False
        '
        'TextBox1
        '
        Me.TextBox1.Location = New System.Drawing.Point(8, 16)
        Me.TextBox1.Multiline = True
        Me.TextBox1.Name = "TextBox1"
        Me.TextBox1.Size = New System.Drawing.Size(184, 64)
        Me.TextBox1.TabIndex = 0
        Me.TextBox1.Text = ""
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(208, 222)
        Me.Controls.Add(Me.GroupBox2)
        Me.Controls.Add(Me.GroupBox1)
        Me.MaximizeBox = False
        Me.Name = "Form1"
        Me.Text = "F4SM Client"
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox2.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    '###
    '### >The main call to get the data from the SharedMemory area and send it to a client.
    '###
    Private Sub getData()

        Dim SendString As String

        ' The object 
        Dim F4 As New F4SM.F4SMGet

        ' Refresh the data from the sharedmemory. (getting the data !)
        F4.RefreshData()

        ' Example string which you can send to a client. I added the time just for debugging.
        SendString = CDec(Hour(Now)) & ":" & CDec(Minute(Now)) & ":" & CDec(Second(Now)) & ":->" & _
        F4.FD.f4_kias & ";" & _
        F4.FD.f4_rpm & ";" & _
        F4.FD.f4_oilPressure & ";" & _
        ""

        ' Send the data using UDP to a client. (Localhost: 127.0.0.1) 
        F4.SendData(IPAddress, 10080, SendString)

        ' For debugging purposes adding the string to a textbox to see what is sended.
        TextBox1.Text = SendString

        ' Destroy the object
        F4 = Nothing

    End Sub
    '###
    '### /The main call to get the data from the SharedMemory area and send it to a client.
    '###


#Region " Just stuff from this demo "
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        IPAddress = tbServerIP.Text
        Timer1.Enabled = True
        Label3.Visible = True
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        Label3.Visible = False
        getData()
    End Sub

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        IPAddress = tbServerIP.Text
        Timer1.Enabled = True
    End Sub
#End Region


End Class
