VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmF4Dat 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Falcon-A"
   ClientHeight    =   4725
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   9660
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "F4Dat.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4725
   ScaleWidth      =   9660
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame fraF4Dat 
      Caption         =   "TCP/IP Info"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3645
      Index           =   2
      Left            =   60
      TabIndex        =   8
      Top             =   990
      Width           =   6945
      Begin VB.TextBox fldPort 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   1005
         TabIndex        =   16
         Text            =   "1001"
         Top             =   1455
         Width           =   1545
      End
      Begin VB.CheckBox chkF4Dat 
         Caption         =   "Transmit TCP/IP"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   0
         Left            =   1005
         TabIndex        =   10
         Top             =   210
         Width           =   1755
      End
      Begin VB.ListBox lstTCPIPDebug 
         Height          =   1530
         Left            =   105
         TabIndex        =   9
         Top             =   1995
         Width           =   6690
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   1  'Right Justify
         Caption         =   "Connections:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Index           =   11
         Left            =   3585
         TabIndex        =   18
         Top             =   660
         Width           =   1230
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   345
         Index           =   10
         Left            =   4875
         TabIndex        =   17
         Top             =   630
         Width           =   1545
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   1  'Right Justify
         Caption         =   "Port:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Index           =   9
         Left            =   150
         TabIndex        =   15
         Top             =   1440
         Width           =   795
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   345
         Index           =   8
         Left            =   1005
         TabIndex        =   14
         Top             =   1035
         Width           =   1545
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   345
         Index           =   7
         Left            =   1005
         TabIndex        =   13
         Top             =   630
         Width           =   1545
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   1  'Right Justify
         Caption         =   "Host IP:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Index           =   6
         Left            =   150
         TabIndex        =   12
         Top             =   1065
         Width           =   795
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   1  'Right Justify
         Caption         =   "Host ID:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Index           =   5
         Left            =   135
         TabIndex        =   11
         Top             =   660
         Width           =   810
      End
   End
   Begin VB.Frame fraF4Dat 
      Caption         =   "Memory Model"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   870
      Index           =   1
      Left            =   7125
      TabIndex        =   4
      Top             =   105
      Width           =   2475
      Begin VB.ComboBox cboF4Dat 
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Index           =   0
         Left            =   135
         Style           =   2  'Dropdown List
         TabIndex        =   7
         Top             =   360
         Width           =   2220
      End
   End
   Begin MSWinsockLib.Winsock FnASock 
      Index           =   0
      Left            =   9690
      Top             =   180
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Frame fraF4Dat 
      Caption         =   "Program Status"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   870
      Index           =   0
      Left            =   60
      TabIndex        =   1
      Top             =   105
      Width           =   6945
      Begin MSComctlLib.Slider sldF4Dat 
         Height          =   270
         Index           =   0
         Left            =   3840
         TabIndex        =   5
         Top             =   420
         Width           =   1890
         _ExtentX        =   3334
         _ExtentY        =   476
         _Version        =   393216
         Min             =   1
         Max             =   500
         SelStart        =   250
         TickStyle       =   3
         Value           =   250
         TextPosition    =   1
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   330
         Index           =   3
         Left            =   5865
         TabIndex        =   6
         Top             =   360
         Width           =   690
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   1  'Right Justify
         Caption         =   "F4 Timer (ms):"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Index           =   1
         Left            =   1980
         TabIndex        =   3
         Top             =   405
         Width           =   1845
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Falcon Active"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H000000FF&
         Height          =   390
         Index           =   0
         Left            =   90
         TabIndex        =   2
         Top             =   315
         Width           =   1770
      End
   End
   Begin VB.Timer tmrF4Dat 
      Enabled         =   0   'False
      Index           =   0
      Interval        =   100
      Left            =   9705
      Top             =   675
   End
   Begin VB.CommandButton cmdF4Dat 
      Caption         =   "&Terminate Falcon-A Server"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   600
      Index           =   0
      Left            =   7155
      TabIndex        =   0
      Top             =   2250
      Width           =   2370
   End
End
Attribute VB_Name = "frmF4Dat"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'
'  ______            Falcon-A Shared Memory File Reader
'  L,.   ',              2004 - 2006 - Team Banzai
'   \      ',_
'    \   @   ',
'     \ ^~^    ',
'      \    SC   ',
'       \___157VFS ',_                          _..----.._
'       [______       "'==.I\_____________..--"<__\\_n@___4\,_
'     ,..-=T         __   ____________          \/  "'" 0<==  "'-+.._
'     I____|_____    }_>=========I>=**""''==-------------==-   " |   "'-.,___
'   [_____,.--'"                             ""--=<""-----=====+==--''""
'     ""'-=+..,,__,-----,_____                  -=* |
'                 |__   /-----'#------.,I_---------'"
'                    """"'--..__         _.>
'                               ""'''''""

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Graphic Courtesy of Unknown artists via Angela Deth
'
' Adapted from code by Erwin Neyt - Eagle 9 Systems
' Thanks to those @ ViperPit.Org who helped and for Jeff "Ref" Owen's Input
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  Option Explicit
 
  Dim glPSharedMem As Long                                         ' Shared memory
  Dim ghSharedMem                                                  ' Shared Memory Handle
  Dim mnErrorCounter As Integer                                    ' Error Counter
  Dim gbTCPIPConnect As Boolean                                    ' Connect via TCP/IP option
  Dim gsPacket(84) As String                                       ' TCP/IP Packet (83=all Instrument Array Elements Including LightBits & HSI Bits)
  Dim mbSocketInUse() As Boolean                                   ' Socket In Use Indicator
  
  Const sldFlightData = 0                                          ' Flight Data Timer Setting
  Const sldTCPIP = 1                                               ' TCP/IP Timer Setting
  Const fldMemModel = 0                                            ' Falcon Memory Model Type
  Const tmrFlightData = 0                                          ' Flight Data Timer
  
  Const cmdExit = 0                                                ' Exit Button
  Const fldFalconActive = 0
  Const chkTCPIP = 0                                               ' Enable/Disalbe TCP/IP
  
''  Const fldF4TimerValue = 0
''  Const fldTCPIPTimerValue = 1
  
  Const lblF4TimerValue = 3
  Const lblTCPIPTimerValue = 4
  
  ' Row Cross Reference for TCP/IP Packet Array
  ' NOTE:  This Array MUST Match the Cross Reference Array in Client Modules
  Const rowTCP_ShipNorth = 0                          ' Ownship North (Ft)
  Const rowTCP_ShipEast = 1                           ' Ownship East (Ft)
  Const rowTCP_ShipDown = 2                           ' Ownship Down (Ft)
  Const rowTCP_ShipNorthRate = 3                      ' Ownship North Rate (ft/sec)
  Const rowTCP_ShipEastRate = 4                       ' Ownship East Rate (ft/sec)
  Const rowTCP_ShipDownRate = 5                       ' Ownship Down Rate (ft/sec)
  Const rowTCP_Alpha = 6                              ' Ownship AOA (Degrees)
  Const rowTCP_Beta = 7                               ' Ownship Beta (Degrees)
  Const rowTCP_Gamma = 8                              ' Ownship Gamma (Radians)
  Const rowTCP_Pitch = 9                              ' Ownship Pitch (Radians)
  Const rowTCP_Roll = 10                              ' Ownship Roll (Radians)
  Const rowTCP_Yaw = 11                               ' Ownship Yaw (Radians)
  Const rowTCP_Mach = 12                              ' Ownship Mach number
  Const rowTCP_Kias = 13                              ' Ownship Indicated Airspeed (Knots)
  Const rowTCP_VT = 14                                ' Ownship True Airspeed (Ft/Sec)
  Const rowTCP_GS = 15                                ' Ownship Normal Gs
  Const rowTCP_WindOffset = 16                        ' Wind delta to FPM (Radians)
  Const rowTCP_NozzlePos = 17                         ' Ownship engine nozzle percent open (0-100)
  Const rowTCP_NozzlePos2 = 18                        ' Ownship engine nozzle2 percent open (0-100) - Multi-engine
  Const rowTCP_InternalFuel = 19                      ' Ownship internal fuel (Lbs)
  Const rowTCP_ExternalFuel = 20                      ' Ownship external fuel (Lbs)
  Const rowTCP_FuelFlow = 21                          ' Ownship fuel flow (Lbs/Hour)
  Const rowTCP_RPM = 22                               ' Ownship engine rpm (Percent 0-103)
  Const rowTCP_RPM2 = 23                              ' Ownship engine rpm2 (Percent 0-103) - multi-engine
  Const rowTCP_FTIT = 24                              ' Ownship Forward Turbine Inlet Temp (Degrees C)
  Const rowTCP_FTIT2 = 25                             ' Ownship Forward Turbine Inlet Temp2 (Degrees C)- multi-engine
  Const rowTCP_GearPos = 26                           ' Ownship Gear position 0 = up, 1 = down;
  Const rowTCP_SpeedBrake = 27                        ' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
  Const rowTCP_EPUFuel = 28                           ' Ownship EPU fuel (Percent 0-100)
  Const rowTCP_OilPressure = 29                       ' Ownship Oil Pressure (Percent 0-100)
  Const rowTCP_OilPressure2 = 30                      ' Ownship Oil Pressure2 (Percent 0-100)- Multi-engine
  Const rowTCP_LightBits = 31                         ' Cockpit Indicator Lights, one bit per bulb.
  Const rowTCP_HeadPitch = 32                         ' Head pitch offset from design eye (radians)
  Const rowTCP_HeadRoll = 33                          ' Head roll offset from design eye (radians)
  Const rowTCP_HeadYaw = 34                           ' Head yaw offset from design eye (radians)
  Const rowTCP_lightBits2 = 35                        ' Cockpit Indicator Lights, one bit per bulb. See enum
  Const rowTCP_lightBits3 = 36                        ' Cockpit Indicator Lights, one bit per bulb. See enum
  Const rowTCP_ChaffCount = 37                        ' Number of Chaff left
  Const rowTCP_FlareCount = 38                        ' Number of Flare left
  Const rowTCP_NoseGearPos = 39                       ' Position of the nose landinggear
  Const rowTCP_LeftGearPos = 40                       ' Position of the left landinggear
  Const rowTCP_RightGearPos = 41                      ' Position of the right landinggear
  Const rowTCP_AdiIlsHorPos = 42                      ' Position of horizontal ILS bar
  Const rowTCP_AdiIlsVerPos = 43                      ' Position of vertical ILS bar
  Const rowTCP_courseState = 44                       ' HSI_STA_CRS_STATE
  Const rowTCP_headingState = 45                      ' HSI_STA_HDG_STATE
  Const rowTCP_totalStates = 46                       ' HSI_STA_TOTAL_STATES ???
  Const rowTCP_courseDeviation = 47                   ' HSI_VAL_CRS_DEVIATION
  Const rowTCP_desiredCourse = 48                     ' HSI_VAL_DESIRED_CRS
  Const rowTCP_distanceToBeacon = 49                  ' HSI_VAL_DISTANCE_TO_BEACON
  Const rowTCP_bearingToBeacon = 50                   ' HSI_VAL_BEARING_TO_BEACON
  Const rowTCP_currentHeading = 51                    ' HSI_VAL_CURRENT_HEADING
  Const rowTCP_desiredHeading = 52                    ' HSI_VAL_DESIRED_HEADING
  Const rowTCP_deviationLimit = 53                    ' HSI_VAL_DEV_LIMIT
  Const rowTCP_halfDeviationLimit = 54                ' HSI_VAL_HALF_DEV_LIMIT
  Const rowTCP_localizerCourse = 55                   ' HSI_VAL_LOCALIZER_CRS
  Const rowTCP_airbaseX = 56                          ' HSI_VAL_AIRBASE_X
  Const rowTCP_airbaseY = 57                          ' HSI_VAL_AIRBASE_Y
  Const rowTCP_totalValues = 58                       ' HSI_VAL_TOTAL_VALUES  ???
  Const rowTCP_TrimPitch = 59                         ' Value of trim in pitch axis, -0.5 to +0.5
  Const rowTCP_TrimRoll = 60                          ' Value of trim in roll axis, -0.5 to +0.5
  Const rowTCP_TrimYaw = 61                           ' Value of trim in yaw axis, -0.5 to +0.5
  Const rowTCP_hsiBits = 62                           ' HSI flags
  Const rowTCP_DEDLines = 63                          ' DED 25 usable chars
  Const rowTCP_Invert = 64                            ' DED 25 usable chars
  Const rowTCP_PFLLines = 65                          ' PFL 25 usable chars
  Const rowTCP_PFLInvert = 66                         ' PFL 25 usable chars
  Const rowTCP_UFCTChan = 67                          ' UFC TACAN Channel
  Const rowTCP_AUXTChan = 68                          ' AUX TACAN Channel
  Const rowTCP_RWRObjectCount = 69                    ' Number of valid threat objects
  Const rowTCP_RWRSymbol = 70                         ' Type of Threat
  Const rowTCP_Bearing = 71                           ' Bearing of Threat
  Const rowTCP_MissileActivity = 72                   ' Missile is active or beam rider
  Const rowTCP_MissileLaunch = 73                     ' Missile is Launched
  Const rowTCP_Selected = 74                          ' Threat is Selected
  Const rowTCP_Lethality = 75                         ' Lethal Range
  Const rowTCP_FWD = 76                               ' Forward fuel tank Quantity
  Const rowTCP_AFT = 77                               ' Aft fuel tank quantity
  Const rowTCP_Total = 78                             ' Total fuel quantity
  Const rowTCP_LightBitsSet = 79                      ' LightBits Set (?)
  Const rowTCP_LightBits2Set = 80                     ' LightBits2 Set (?)
  Const rowTCP_LightBits3Set = 81                     ' LightBits3 Set (?)
  Const rowTCP_HSISet = 82                            ' HSI Set (?)
  Const rowTCP_VersionNum = 83                        ' Version of sh.mem file
  Const rowTCP_FalconActive = 84                      ' Is Falcon Active
  
  Const rowTCP_Max = 84                               ' Maximum TCP/IP Packet
  Dim mnMaxSocket As Integer                          ' Maximum # of TCP/IP Sockets
  Const fraTCPIPInfo = 2                             ' TCP/IP Debug Frame
  Dim msRequestID As String                            ' TCP/IP Request ID
  Const mnHostID = 7                                  ' TCP/IP Host ID
  Const mnHostIP = 8                                  ' TCP/IP Host IP
  Const mnConnections = 10                            ' TCP/IP Connections
  
  
Private Sub cboF4Dat_LostFocus(index As Integer)
  
  Select Case index
  Case fldMemModel
    With cboF4Dat(fldMemModel)
      Select Case .Text
      Case "Open Falcon"
        gsFalconVersion = "OF"
      Case "BMS 2.x"
        gsFalconVersion = "BMS2"
      Case "Allied Force"
        gsFalconVersion = "AF"
      End Select
    End With
  End Select
End Sub

Private Sub chkF4Dat_Click(index As Integer)
' Check Box Click
  Dim mnCounter As Integer
  
  With chkF4Dat(index)
    Select Case index
    Case chkTCPIP                                                       ' TCP/IP Output Selected
      If chkF4Dat(chkTCPIP).Value = vbChecked Then
        lblF4Dat(mnHostID) = FnASock(0).LocalHostName
        lblF4Dat(mnHostIP) = FnASock(0).LocalIP
        FnASock(0).LocalPort = Val(fldPort.Text)                        ' Port zero used for listening
        #If jrDebugMode Then
          lstTCPIPDebug.AddItem "Listening to Port: " & FnASock(0).LocalPort
        #End If
        FnASock(0).Listen
      End If
      mnMaxSocket = 0
    End Select
  End With
End Sub

Private Sub cmdF4Dat_Click(index As Integer)
' Button Support
  Select Case index
  Case cmdExit
    Unload Me
    End
  End Select

End Sub

Private Sub FnASock_Close(index As Integer)
  #If jrDebugMode Then
    lstTCPIPDebug.AddItem "Connection closed: " & FnASock(index).RemoteHostIP
  #End If
  FnASock(index).Close
  Unload FnASock(index)
  mnMaxSocket = mnMaxSocket - 1
  lblF4Dat(mnConnections).Caption = mnMaxSocket
  
End Sub

Private Sub FnASock_Connect(index As Integer)
  DoEvents
End Sub

Private Sub FnASock_ConnectionRequest(index As Integer, ByVal requestID As Long)
  
  ' Accept the Connection for RequestID
  If index = 0 Then
    #If jrDebugMode Then
      lstTCPIPDebug.AddItem "Connection request id " & requestID & " from " & FnASock(index).RemoteHostIP
    #End If
    msRequestID = requestID
    mnMaxSocket = mnMaxSocket + 1
    lblF4Dat(mnConnections).Caption = mnMaxSocket
    Load FnASock(mnMaxSocket)
    FnASock(mnMaxSocket).LocalPort = Val(fldPort.Text)
    FnASock(mnMaxSocket).Accept requestID
  End If

End Sub

Private Sub FnASock_DataArrival(index As Integer, ByVal bytesTotal As Long)
  Dim msData As String
  With FnASock(index)
    .GetData msData, vbString
    #If jrDebugMode Then
      lstTCPIPDebug.AddItem "Received: " & msData & " from " & .RemoteHostIP & "(" & msRequestID & ")"
    #End If
    If msData = "X" Then                                     ' Single X Checks for Falcon Status
      #If jrDebugMode Then
        lstTCPIPDebug.AddItem "Sending: " & gbFalconActive & " from " & .RemoteHostIP & "(" & msRequestID & ")"
      #End If
      .SendData gbFalconActive
    Else                                                     ' XXX Gets Full Falcon Status
      BlowItOutYourTCPIPPort index                           ' Blast Out TCP/IP Data
    End If
  End With
End Sub

Private Sub Form_Load()
  ' Startup Procedure
  Dim mnCounter As Integer
  
  On Error GoTo FLErr
  With App
    If .PrevInstance Then
      MsgBox "A Previous Instance of Falcon-A Server Is Running.  Please Press Ok", vbOKOnly, "Duplicate Execution"
      End
    End If
    Me.Caption = .FileDescription & " (v" & .Major & "." & .Minor & .Revision & ")"
  End With
  
  With Me                                                         ' Window Placement
    .Left = Screen.Width - .Width - 100
    .Top = 500
    #If jrDebugMode Then
       .Height = 5205
       fraF4Dat(fraTCPIPInfo).Height = 3645
       lstTCPIPDebug.Visible = True
    #Else
      .Height = 3660
      fraF4Dat(fraTCPIPInfo).Height = 1965
      lstTCPIPDebug.Visible = False
    #End If
    
  End With
  gbFalconActive = False
  
  ' Chose the version you want to work with

  With cboF4Dat(fldMemModel)
    .Clear
    .AddItem "Open Falcon"
    .AddItem "BMS 2.x"
    .AddItem "Allied Force"
    .ListIndex = 0
    cboF4Dat_LostFocus (fldMemModel)
  End With
  
  mnMaxSocket = 5                                                 ' Hard coded 5 socket maximum
  ReDim mbSocketInUse(mnMaxSocket)                                ' Set up array to track Sockets in use
  
  With lblF4Dat(fldFalconActive)
    .Caption = "Falcon Inactive"
    .ForeColor = &HFF&
  End With
  
  tmrF4Dat(tmrFlightData).Interval = sldF4Dat(sldFlightData).Value
  lblF4Dat(lblF4TimerValue).Caption = sldF4Dat(sldFlightData).Value
  
  ' Setup TCP/IP
  'chkF4Dat(chkTCPIP).Value = vbChecked                             ' Hard-coded now, variable later
  gbTCPIPConnect = False                                           ' No Connection yet established
  
  DoEvents
  mnErrorCounter = 0
  gbFalconActive = False                                           ' Set Falcon Open Bit to False on Startup
  tmrF4Dat(tmrFlightData).Enabled = True
  Exit Sub
  
FLErr:
  MsgBox Err.Description & vbCr & "Generated by: " & Err.Source & "(" & Err.Number & ")" & vbCr & Err.HelpFile & vbCr & Err.HelpContext, vbOKOnly, "Falcon-A Error"
  YouAreTerminated

End Sub

Private Sub Form_Terminate()
  YouAreTerminated
End Sub

Private Sub Form_Unload(Cancel As Integer)
  YouAreTerminated
End Sub
Private Sub OpenF4SharedMemFile()
' Open the Falcon 4 Shared Memory File

  On Error GoTo OSMFErr
  
  ' Attempt to open F4 Shared Memory
  ghSharedMem = OpenFileMapping(FILE_MAP_READ, True, "FalconSharedMemoryArea")
  
  If ghSharedMem > 0 Then                                         ' Successful Open - Handle Obtained
    glPSharedMem = MapViewOfFile(ghSharedMem, FILE_MAP_READ, 0, 0, 0)
    gbFalconActive = True
  Else                                                            ' Unable to open the shared memory file
    'UnmapViewOfFile (glPSharedMem)
    CloseHandle (ghSharedMem)
    gbFalconActive = False
  End If
  
  ' Set Falcon Active Indicator
  With lblF4Dat(fldFalconActive)
    .Caption = IIf(gbFalconActive, "Falcon-A", "Falcon Inactive")
    .ForeColor = IIf(gbFalconActive, &HFF00&, &HFF&)
    .FontBold = gbFalconActive
  End With
  DoEvents
  Exit Sub
  
OSMFErr:
  MsgBox Err.Description & vbCr & "Generated by: " & Err.Source & "(" & Err.Number & ")" & vbCr & Err.HelpFile & vbCr & Err.HelpContext, vbOKOnly, "Falcon-A Error"
  YouAreTerminated
  

End Sub
Private Sub BlowItOutYourTCPIPPort(mnSocket As Integer)
' Format Data an Transmit via TCP/IP Port
' Parameters:  mnSocket   - TCP/IP Socket Number
Dim mnCounter As Integer
  Dim mvPacket As Variant
  
  On Error GoTo FFDErr
  
  Select Case gsFalconVersion
  Case "OF"
    With FDOF
      gsPacket(rowTCP_ShipNorth) = Chr(13) & CStr(.ShipNorth)
      gsPacket(rowTCP_ShipEast) = Chr(13) & CStr(.ShipEast)
      gsPacket(rowTCP_ShipDown) = Chr(13) & CStr(.ShipDown)
      gsPacket(rowTCP_ShipNorthRate) = Chr(13) & CStr(.ShipNorthRate)
      gsPacket(rowTCP_ShipEastRate) = Chr(13) & CStr(.ShipEastRate)
      gsPacket(rowTCP_ShipDownRate) = Chr(13) & CStr(.ShipDownRate)
      gsPacket(rowTCP_Alpha) = Chr(13) & CStr(.Alpha)
      gsPacket(rowTCP_Beta) = Chr(13) & CStr(.Beta)
      gsPacket(rowTCP_Gamma) = Chr(13) & CStr(.Gamma)
      gsPacket(rowTCP_Pitch) = Chr(13) & CStr(.Pitch)
      gsPacket(rowTCP_Roll) = Chr(13) & CStr(.Roll)
      gsPacket(rowTCP_Yaw) = Chr(13) & CStr(.Yaw)
      gsPacket(rowTCP_Mach) = Chr(13) & CStr(.Mach)
      gsPacket(rowTCP_Kias) = Chr(13) & CStr(.KIAS)
      gsPacket(rowTCP_VT) = Chr(13) & CStr(.VT)
      gsPacket(rowTCP_GS) = Chr(13) & CStr(.GS)
      gsPacket(rowTCP_WindOffset) = Chr(13) & CStr(.WindOffset)
      gsPacket(rowTCP_NozzlePos) = Chr(13) & CStr(.NozzlePos)
      gsPacket(rowTCP_NozzlePos2) = Chr(13) & CStr(0)
      gsPacket(rowTCP_InternalFuel) = Chr(13) & (.InternalFuel)
      gsPacket(rowTCP_ExternalFuel) = Chr(13) & CStr(.ExternalFuel)
      gsPacket(rowTCP_FuelFlow) = Chr(13) & CStr(.FuelFlow)
      gsPacket(rowTCP_RPM) = Chr(13) & CStr(.RPM)
      gsPacket(rowTCP_RPM2) = Chr(13) & CStr(0)
      gsPacket(rowTCP_FTIT) = Chr(13) & CStr(.FTIT)
      gsPacket(rowTCP_FTIT2) = Chr(13) & CStr(0)
      gsPacket(rowTCP_GearPos) = Chr(13) & CStr(.GearPos)
      gsPacket(rowTCP_SpeedBrake) = Chr(13) & CStr(.SpeedBrake)
      gsPacket(rowTCP_EPUFuel) = Chr(13) & CStr(.EPUFuel)
      gsPacket(rowTCP_OilPressure) = Chr(13) & CStr(.OilPressure)
      gsPacket(rowTCP_OilPressure2) = Chr(13) & CStr(0)
      gsPacket(rowTCP_LightBits) = Chr(13) & CStr(.LightBits)
      gsPacket(rowTCP_HeadPitch) = Chr(13) & CStr(.HeadPitch)
      gsPacket(rowTCP_HeadRoll) = Chr(13) & CStr(.HeadRoll)
      gsPacket(rowTCP_HeadYaw) = Chr(13) & CStr(.HeadYaw)
      gsPacket(rowTCP_lightBits2) = Chr(13) & CStr(.LightBits2)
      gsPacket(rowTCP_lightBits3) = Chr(13) & CStr(.LightBits3)
      gsPacket(rowTCP_ChaffCount) = Chr(13) & CStr(.ChaffCount)
      gsPacket(rowTCP_FlareCount) = Chr(13) & CStr(.FlareCount)
      gsPacket(rowTCP_NoseGearPos) = Chr(13) & CStr(.NoseGearPos)
      gsPacket(rowTCP_LeftGearPos) = Chr(13) & CStr(.LeftGearPos)
      gsPacket(rowTCP_RightGearPos) = Chr(13) & CStr(.RightGearPos)
      gsPacket(rowTCP_AdiIlsHorPos) = Chr(13) & CStr(.AdiIlsHorPos)
      gsPacket(rowTCP_AdiIlsVerPos) = Chr(13) & CStr(.AdiIlsVerPos)
      gsPacket(rowTCP_courseState) = Chr(13) & CStr(.CourseState)
      gsPacket(rowTCP_headingState) = Chr(13) & CStr(.HeadingState)
      gsPacket(rowTCP_totalStates) = Chr(13) & CStr(.TotalStates)
      gsPacket(rowTCP_courseDeviation) = Chr(13) & CStr(.CourseDeviation)
      gsPacket(rowTCP_desiredCourse) = Chr(13) & CStr(.DesiredCourse)
      gsPacket(rowTCP_distanceToBeacon) = Chr(13) & CStr(.DistanceToBeacon)
      gsPacket(rowTCP_bearingToBeacon) = Chr(13) & CStr(.BearingToBeacon)
      gsPacket(rowTCP_currentHeading) = Chr(13) & CStr(.CurrentHeading)
      gsPacket(rowTCP_desiredHeading) = Chr(13) & CStr(.DesiredHeading)
      gsPacket(rowTCP_deviationLimit) = Chr(13) & CStr(.DeviationLimit)
      gsPacket(rowTCP_halfDeviationLimit) = Chr(13) & CStr(.HalfDeviationLimit)
      gsPacket(rowTCP_localizerCourse) = Chr(13) & CStr(.LocalizerCourse)
      gsPacket(rowTCP_airbaseX) = Chr(13) & CStr(.AirBaseX)
      gsPacket(rowTCP_airbaseY) = Chr(13) & CStr(.AirBaseY)
      gsPacket(rowTCP_totalValues) = Chr(13) & CStr(.TotalValues)
      gsPacket(rowTCP_TrimPitch) = Chr(13) & CStr(.TrimPitch)
      gsPacket(rowTCP_TrimRoll) = Chr(13) & CStr(.TrimRoll)
      gsPacket(rowTCP_TrimYaw) = Chr(13) & CStr(.TrimYaw)
      gsPacket(rowTCP_hsiBits) = Chr(13) & CStr(.HSIBits)
      gsPacket(rowTCP_DEDLines) = Chr(13) & CStr(.DEDLines)
      gsPacket(rowTCP_Invert) = Chr(13) & CStr(.Invert)
      gsPacket(rowTCP_PFLLines) = Chr(13) & CStr(.PFLLines)
      gsPacket(rowTCP_PFLInvert) = Chr(13) & CStr(.PFLInvert)
      gsPacket(rowTCP_UFCTChan) = Chr(13) & CStr(.UFCTChan)
      gsPacket(rowTCP_AUXTChan) = Chr(13) & CStr(.AUXTChan)
      gsPacket(rowTCP_RWRObjectCount) = Chr(13) & CStr(.RWRObjectCount)
      ' Build Array Data for Bearing, MissileActivity, MissileLaunch, Selected, Lethality (all arrays same size - 20)
      gsPacket(rowTCP_RWRSymbol) = Chr(13)
      gsPacket(rowTCP_Bearing) = Chr(13)
      gsPacket(rowTCP_MissileActivity) = Chr(13)
      gsPacket(rowTCP_MissileLaunch) = Chr(13)
      gsPacket(rowTCP_Selected) = Chr(13)
      gsPacket(rowTCP_Lethality) = Chr(13)
      For mnCounter = 0 To 39                           ' Hard Coded for 40 array elements (Open Falcon)
        gsPacket(rowTCP_RWRSymbol) = gsPacket(rowTCP_RWRSymbol) & CStr(.RWRSymbol(mnCounter)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_Bearing) = gsPacket(rowTCP_Bearing) & CStr(.Bearing(mnCounter)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_MissileActivity) = gsPacket(rowTCP_MissileActivity) & CStr(.MissileActivity(1)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_MissileLaunch) = gsPacket(rowTCP_MissileLaunch) & CStr(.MissileLaunch(1)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_Selected) = gsPacket(rowTCP_Selected) & CStr(.Selected(1)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_Lethality) = gsPacket(rowTCP_Lethality) & CStr(.Lethality(1)) & IIf(mnCounter = 39, "", "/")
      Next mnCounter
      gsPacket(rowTCP_FWD) = Chr(13) & CStr(.FWDFuel)
      gsPacket(rowTCP_AFT) = Chr(13) & CStr(.AFTFuel)
      gsPacket(rowTCP_Total) = Chr(13) & CStr(.TotalFuel)
      gsPacket(rowTCP_LightBitsSet) = Chr(13) & CStr(.LightBitsSet)
      gsPacket(rowTCP_LightBits2Set) = Chr(13) & CStr(.LightBits2Set)
      gsPacket(rowTCP_LightBits3Set) = Chr(13) & CStr(.LightBits3Set)
      gsPacket(rowTCP_HSISet) = Chr(13) & CStr(.HSISet)
      gsPacket(rowTCP_VersionNum) = Chr(13) & CStr(.VersionNum)
    End With
    gsPacket(rowTCP_FalconActive) = Chr(13) & CStr(Abs(CInt(gbFalconActive)))
  Case "BMS2"
    With FDBMS2
      gsPacket(rowTCP_ShipNorth) = Chr(13) & CStr(.ShipNorth)
      gsPacket(rowTCP_ShipEast) = Chr(13) & CStr(.ShipEast)
      gsPacket(rowTCP_ShipDown) = Chr(13) & CStr(.ShipDown)
      gsPacket(rowTCP_ShipNorthRate) = Chr(13) & CStr(.ShipNorthRate)
      gsPacket(rowTCP_ShipEastRate) = Chr(13) & CStr(.ShipEastRate)
      gsPacket(rowTCP_ShipDownRate) = Chr(13) & CStr(.ShipDownRate)
      gsPacket(rowTCP_Alpha) = Chr(13) & CStr(.Alpha)
      gsPacket(rowTCP_Beta) = Chr(13) & CStr(.Beta)
      gsPacket(rowTCP_Gamma) = Chr(13) & CStr(.Gamma)
      gsPacket(rowTCP_Pitch) = Chr(13) & CStr(.Pitch)
      gsPacket(rowTCP_Roll) = Chr(13) & CStr(.Roll)
      gsPacket(rowTCP_Yaw) = Chr(13) & CStr(.Yaw)
      gsPacket(rowTCP_Mach) = Chr(13) & CStr(.Mach)
      gsPacket(rowTCP_Kias) = Chr(13) & CStr(.KIAS)
      gsPacket(rowTCP_VT) = Chr(13) & CStr(.VT)
      gsPacket(rowTCP_GS) = Chr(13) & CStr(.GS)
      gsPacket(rowTCP_WindOffset) = Chr(13) & CStr(.WindOffset)
      gsPacket(rowTCP_NozzlePos) = Chr(13) & CStr(.NozzlePos)
      gsPacket(rowTCP_NozzlePos2) = Chr(13) & CStr(.NozzlePos2)
      gsPacket(rowTCP_InternalFuel) = Chr(13) & (.InternalFuel)
      gsPacket(rowTCP_ExternalFuel) = Chr(13) & CStr(.ExternalFuel)
      gsPacket(rowTCP_FuelFlow) = Chr(13) & CStr(.FuelFlow)
      gsPacket(rowTCP_RPM) = Chr(13) & CStr(.RPM)
      gsPacket(rowTCP_RPM2) = Chr(13) & CStr(.RPM2)
      gsPacket(rowTCP_FTIT) = Chr(13) & CStr(.FTIT)
      gsPacket(rowTCP_FTIT2) = Chr(13) & CStr(.FTIT2)
      gsPacket(rowTCP_GearPos) = Chr(13) & CStr(.GearPos)
      gsPacket(rowTCP_SpeedBrake) = Chr(13) & CStr(.SpeedBrake)
      gsPacket(rowTCP_EPUFuel) = Chr(13) & CStr(.EPUFuel)
      gsPacket(rowTCP_OilPressure) = Chr(13) & CStr(.OilPressure)
      gsPacket(rowTCP_OilPressure2) = Chr(13) & CStr(.OilPressure2)
      gsPacket(rowTCP_LightBits) = Chr(13) & CStr(.LightBits)
      gsPacket(rowTCP_HeadPitch) = Chr(13) & CStr(.HeadPitch)
      gsPacket(rowTCP_HeadRoll) = Chr(13) & CStr(.HeadRoll)
      gsPacket(rowTCP_HeadYaw) = Chr(13) & CStr(.HeadYaw)
      gsPacket(rowTCP_lightBits2) = Chr(13) & CStr(.LightBits2)
      gsPacket(rowTCP_lightBits3) = Chr(13) & CStr(.LightBits3)
      gsPacket(rowTCP_ChaffCount) = Chr(13) & CStr(.ChaffCount)
      gsPacket(rowTCP_FlareCount) = Chr(13) & CStr(.FlareCount)
      gsPacket(rowTCP_NoseGearPos) = Chr(13) & CStr(.NoseGearPos)
      gsPacket(rowTCP_LeftGearPos) = Chr(13) & CStr(.LeftGearPos)
      gsPacket(rowTCP_RightGearPos) = Chr(13) & CStr(.RightGearPos)
      gsPacket(rowTCP_AdiIlsHorPos) = Chr(13) & CStr(.AdiIlsHorPos)
      gsPacket(rowTCP_AdiIlsVerPos) = Chr(13) & CStr(.AdiIlsVerPos)
      gsPacket(rowTCP_courseState) = Chr(13) & CStr(.CourseState)
      gsPacket(rowTCP_headingState) = Chr(13) & CStr(.HeadingState)
      gsPacket(rowTCP_totalStates) = Chr(13) & CStr(.TotalStates)
      gsPacket(rowTCP_courseDeviation) = Chr(13) & CStr(.CourseDeviation)
      gsPacket(rowTCP_desiredCourse) = Chr(13) & CStr(.DesiredCourse)
      gsPacket(rowTCP_distanceToBeacon) = Chr(13) & CStr(.DistanceToBeacon)
      gsPacket(rowTCP_bearingToBeacon) = Chr(13) & CStr(.BearingToBeacon)
      gsPacket(rowTCP_currentHeading) = Chr(13) & CStr(.CurrentHeading)
      gsPacket(rowTCP_desiredHeading) = Chr(13) & CStr(.DesiredHeading)
      gsPacket(rowTCP_deviationLimit) = Chr(13) & CStr(.DeviationLimit)
      gsPacket(rowTCP_halfDeviationLimit) = Chr(13) & CStr(.HalfDeviationLimit)
      gsPacket(rowTCP_localizerCourse) = Chr(13) & CStr(.LocalizerCourse)
      gsPacket(rowTCP_airbaseX) = Chr(13) & CStr(.AirBaseX)
      gsPacket(rowTCP_airbaseY) = Chr(13) & CStr(.AirBaseY)
      gsPacket(rowTCP_totalValues) = Chr(13) & CStr(.TotalValues)
      gsPacket(rowTCP_TrimPitch) = Chr(13) & CStr(.TrimPitch)
      gsPacket(rowTCP_TrimRoll) = Chr(13) & CStr(.TrimRoll)
      gsPacket(rowTCP_TrimYaw) = Chr(13) & CStr(.TrimYaw)
      gsPacket(rowTCP_hsiBits) = Chr(13) & CStr(.HSIBits)
      gsPacket(rowTCP_DEDLines) = Chr(13) & CStr(.DEDLines)
      gsPacket(rowTCP_Invert) = Chr(13) & CStr(.Invert)
      gsPacket(rowTCP_PFLLines) = Chr(13) & CStr(.PFLLines)
      gsPacket(rowTCP_PFLInvert) = Chr(13) & CStr(.PFLInvert)
      gsPacket(rowTCP_UFCTChan) = Chr(13) & CStr(.UFCTChan)
      gsPacket(rowTCP_AUXTChan) = Chr(13) & CStr(.AUXTChan)
      gsPacket(rowTCP_RWRObjectCount) = Chr(13) & CStr(.RWRObjectCount)
      ' Build Array Data for Bearing, MissileActivity, MissileLaunch, Selected, Lethality (all arrays same size - 20)
      gsPacket(rowTCP_RWRSymbol) = Chr(13)
      gsPacket(rowTCP_Bearing) = Chr(13)
      gsPacket(rowTCP_MissileActivity) = Chr(13)
      gsPacket(rowTCP_MissileLaunch) = Chr(13)
      gsPacket(rowTCP_Selected) = Chr(13)
      gsPacket(rowTCP_Lethality) = Chr(13)
      For mnCounter = 0 To 19                           ' Hard Coded for 20 array elements (BMS)
        gsPacket(rowTCP_RWRSymbol) = gsPacket(rowTCP_RWRSymbol) & CStr(.RWRSymbol(mnCounter)) & IIf(mnCounter = 19, "", "/")
        gsPacket(rowTCP_Bearing) = gsPacket(rowTCP_Bearing) & CStr(.Bearing(mnCounter)) & IIf(mnCounter = 19, "", "/")
        gsPacket(rowTCP_MissileActivity) = gsPacket(rowTCP_MissileActivity) & CStr(.MissileActivity(1)) & IIf(mnCounter = 19, "", "/")
        gsPacket(rowTCP_MissileLaunch) = gsPacket(rowTCP_MissileLaunch) & CStr(.MissileLaunch(1)) & IIf(mnCounter = 19, "", "/")
        gsPacket(rowTCP_Selected) = gsPacket(rowTCP_Selected) & CStr(.Selected(1)) & IIf(mnCounter = 19, "", "/")
        gsPacket(rowTCP_Lethality) = gsPacket(rowTCP_Lethality) & CStr(.Lethality(1)) & IIf(mnCounter = 19, "", "/")
      Next mnCounter
      gsPacket(rowTCP_FWD) = Chr(13) & CStr(.FWDFuel)
      gsPacket(rowTCP_AFT) = Chr(13) & CStr(.AFTFuel)
      gsPacket(rowTCP_Total) = Chr(13) & CStr(.TotalFuel)
      gsPacket(rowTCP_LightBitsSet) = Chr(13) & CStr(.LightBitsSet)
      gsPacket(rowTCP_LightBits2Set) = Chr(13) & CStr(.LightBits2Set)
      gsPacket(rowTCP_LightBits3Set) = Chr(13) & CStr(.LightBits3Set)
      gsPacket(rowTCP_HSISet) = Chr(13) & CStr(.HSISet)
      gsPacket(rowTCP_VersionNum) = Chr(13) & CStr(.VersionNum)
    End With
    gsPacket(rowTCP_FalconActive) = Chr(13) & CStr(Abs(CInt(gbFalconActive)))
    
  Case "AF"
    With FDAF
      gsPacket(rowTCP_ShipNorth) = Chr(13) & CStr(.ShipNorth)
      gsPacket(rowTCP_ShipEast) = Chr(13) & CStr(.ShipEast)
      gsPacket(rowTCP_ShipDown) = Chr(13) & CStr(.ShipDown)
      gsPacket(rowTCP_ShipNorthRate) = Chr(13) & CStr(.ShipNorthRate)
      gsPacket(rowTCP_ShipEastRate) = Chr(13) & CStr(.ShipEastRate)
      gsPacket(rowTCP_ShipDownRate) = Chr(13) & CStr(.ShipDownRate)
      gsPacket(rowTCP_Alpha) = Chr(13) & CStr(.Alpha)
      gsPacket(rowTCP_Beta) = Chr(13) & CStr(.Beta)
      gsPacket(rowTCP_Gamma) = Chr(13) & CStr(.Gamma)
      gsPacket(rowTCP_Pitch) = Chr(13) & CStr(.Pitch)
      gsPacket(rowTCP_Roll) = Chr(13) & CStr(.Roll)
      gsPacket(rowTCP_Yaw) = Chr(13) & CStr(.Yaw)
      gsPacket(rowTCP_Mach) = Chr(13) & CStr(.Mach)
      gsPacket(rowTCP_Kias) = Chr(13) & CStr(.KIAS)
      gsPacket(rowTCP_VT) = Chr(13) & CStr(.VT)
      gsPacket(rowTCP_GS) = Chr(13) & CStr(.GS)
      gsPacket(rowTCP_WindOffset) = Chr(13) & CStr(.WindOffset)
      gsPacket(rowTCP_NozzlePos) = Chr(13) & CStr(.NozzlePos)
      gsPacket(rowTCP_NozzlePos2) = Chr(13) & CStr(0)
      gsPacket(rowTCP_InternalFuel) = Chr(13) & (.InternalFuel)
      gsPacket(rowTCP_ExternalFuel) = Chr(13) & CStr(.ExternalFuel)
      gsPacket(rowTCP_FuelFlow) = Chr(13) & CStr(.FuelFlow)
      gsPacket(rowTCP_RPM) = Chr(13) & CStr(.RPM)
      gsPacket(rowTCP_RPM2) = Chr(13) & CStr(0)
      gsPacket(rowTCP_FTIT) = Chr(13) & CStr(.FTIT)
      gsPacket(rowTCP_FTIT2) = Chr(13) & CStr(0)
      gsPacket(rowTCP_GearPos) = Chr(13) & CStr(.GearPos)
      gsPacket(rowTCP_SpeedBrake) = Chr(13) & CStr(.SpeedBrake)
      gsPacket(rowTCP_EPUFuel) = Chr(13) & CStr(.EPUFuel)
      gsPacket(rowTCP_OilPressure) = Chr(13) & CStr(.OilPressure)
      gsPacket(rowTCP_OilPressure2) = Chr(13) & CStr(0)
      gsPacket(rowTCP_LightBits) = Chr(13) & CStr(.LightBits)
      gsPacket(rowTCP_HeadPitch) = Chr(13) & CStr(.HeadPitch)
      gsPacket(rowTCP_HeadRoll) = Chr(13) & CStr(.HeadRoll)
      gsPacket(rowTCP_HeadYaw) = Chr(13) & CStr(.HeadYaw)
      gsPacket(rowTCP_lightBits2) = Chr(13) & CStr(.LightBits2)
      gsPacket(rowTCP_lightBits3) = Chr(13) & CStr(.LightBits3)
      gsPacket(rowTCP_ChaffCount) = Chr(13) & CStr(.ChaffCount)
      gsPacket(rowTCP_FlareCount) = Chr(13) & CStr(.FlareCount)
      gsPacket(rowTCP_NoseGearPos) = Chr(13) & CStr(.NoseGearPos)
      gsPacket(rowTCP_LeftGearPos) = Chr(13) & CStr(.LeftGearPos)
      gsPacket(rowTCP_RightGearPos) = Chr(13) & CStr(.RightGearPos)
      gsPacket(rowTCP_AdiIlsHorPos) = Chr(13) & CStr(.AdiIlsHorPos)
      gsPacket(rowTCP_AdiIlsVerPos) = Chr(13) & CStr(.AdiIlsVerPos)
      gsPacket(rowTCP_courseState) = Chr(13) & CStr(.CourseState)
      gsPacket(rowTCP_headingState) = Chr(13) & CStr(.HeadingState)
      gsPacket(rowTCP_totalStates) = Chr(13) & CStr(.TotalStates)
      gsPacket(rowTCP_courseDeviation) = Chr(13) & CStr(.CourseDeviation)
      gsPacket(rowTCP_desiredCourse) = Chr(13) & CStr(.DesiredCourse)
      gsPacket(rowTCP_distanceToBeacon) = Chr(13) & CStr(.DistanceToBeacon)
      gsPacket(rowTCP_bearingToBeacon) = Chr(13) & CStr(.BearingToBeacon)
      gsPacket(rowTCP_currentHeading) = Chr(13) & CStr(.CurrentHeading)
      gsPacket(rowTCP_desiredHeading) = Chr(13) & CStr(.DesiredHeading)
      gsPacket(rowTCP_deviationLimit) = Chr(13) & CStr(.DeviationLimit)
      gsPacket(rowTCP_halfDeviationLimit) = Chr(13) & CStr(.HalfDeviationLimit)
      gsPacket(rowTCP_localizerCourse) = Chr(13) & CStr(.LocalizerCourse)
      gsPacket(rowTCP_airbaseX) = Chr(13) & CStr(.AirBaseX)
      gsPacket(rowTCP_airbaseY) = Chr(13) & CStr(.AirBaseY)
      gsPacket(rowTCP_totalValues) = Chr(13) & CStr(.TotalValues)
      gsPacket(rowTCP_TrimPitch) = Chr(13) & CStr(.TrimPitch)
      gsPacket(rowTCP_TrimRoll) = Chr(13) & CStr(.TrimRoll)
      gsPacket(rowTCP_TrimYaw) = Chr(13) & CStr(.TrimYaw)
      gsPacket(rowTCP_hsiBits) = Chr(13) & CStr(.HSIBits)
      gsPacket(rowTCP_DEDLines) = Chr(13) & CStr(.DEDLines)
      gsPacket(rowTCP_Invert) = Chr(13) & CStr(.Invert)
      gsPacket(rowTCP_PFLLines) = Chr(13) & CStr(.PFLLines)
      gsPacket(rowTCP_PFLInvert) = Chr(13) & CStr(.PFLInvert)
      gsPacket(rowTCP_UFCTChan) = Chr(13) & CStr(.UFCTChan)
      gsPacket(rowTCP_AUXTChan) = Chr(13) & CStr(.AUXTChan)
      gsPacket(rowTCP_RWRObjectCount) = Chr(13) & CStr(.RWRObjectCount)
      ' Build Array Data for Bearing, MissileActivity, MissileLaunch, Selected, Lethality (all arrays same size - 20)
      gsPacket(rowTCP_RWRSymbol) = Chr(13)
      gsPacket(rowTCP_Bearing) = Chr(13)
      gsPacket(rowTCP_MissileActivity) = Chr(13)
      gsPacket(rowTCP_MissileLaunch) = Chr(13)
      gsPacket(rowTCP_Selected) = Chr(13)
      gsPacket(rowTCP_Lethality) = Chr(13)
      For mnCounter = 0 To 39                           ' Hard Coded for 40 array elements (Allied Force)
        gsPacket(rowTCP_RWRSymbol) = gsPacket(rowTCP_RWRSymbol) & CStr(.RWRSymbol(mnCounter)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_Bearing) = gsPacket(rowTCP_Bearing) & CStr(.Bearing(mnCounter)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_MissileActivity) = gsPacket(rowTCP_MissileActivity) & CStr(.MissileActivity(1)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_MissileLaunch) = gsPacket(rowTCP_MissileLaunch) & CStr(.MissileLaunch(1)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_Selected) = gsPacket(rowTCP_Selected) & CStr(.Selected(1)) & IIf(mnCounter = 39, "", "/")
        gsPacket(rowTCP_Lethality) = gsPacket(rowTCP_Lethality) & CStr(.Lethality(1)) & IIf(mnCounter = 39, "", "/")
      Next mnCounter
      gsPacket(rowTCP_FWD) = Chr(13) & CStr(.FWDFuel)
      gsPacket(rowTCP_AFT) = Chr(13) & CStr(.AFTFuel)
      gsPacket(rowTCP_Total) = Chr(13) & CStr(.TotalFuel)
      gsPacket(rowTCP_LightBitsSet) = Chr(13) & CStr(.LightBitsSet)
      gsPacket(rowTCP_LightBits2Set) = Chr(13) & CStr(.LightBits2Set)
      gsPacket(rowTCP_LightBits3Set) = Chr(13) & CStr(.LightBits3Set)
      gsPacket(rowTCP_HSISet) = Chr(13) & CStr(.HSISet)
      gsPacket(rowTCP_VersionNum) = Chr(13) & CStr(.VersionNum)
    End With
    gsPacket(rowTCP_FalconActive) = Chr(13) & CStr(Abs(CInt(gbFalconActive)))
    
  End Select
  ' Build Packet
  mvPacket = gsPacket(rowTCP_ShipNorth) & gsPacket(rowTCP_ShipEast) & gsPacket(rowTCP_ShipDown) & gsPacket(rowTCP_ShipNorthRate) & _
    gsPacket(rowTCP_ShipEastRate) & gsPacket(rowTCP_ShipDownRate) & gsPacket(rowTCP_Alpha) & gsPacket(rowTCP_Beta) & gsPacket(rowTCP_Gamma) & _
    gsPacket(rowTCP_Pitch) & gsPacket(rowTCP_Roll) & gsPacket(rowTCP_Yaw) & gsPacket(rowTCP_Mach) & gsPacket(rowTCP_Kias) & _
    gsPacket(rowTCP_VT) & gsPacket(rowTCP_GS) & gsPacket(rowTCP_WindOffset) & gsPacket(rowTCP_NozzlePos) & gsPacket(rowTCP_NozzlePos2) & _
    gsPacket(rowTCP_InternalFuel) & gsPacket(rowTCP_ExternalFuel) & gsPacket(rowTCP_FuelFlow) & gsPacket(rowTCP_RPM) & gsPacket(rowTCP_RPM2) & _
    gsPacket(rowTCP_FTIT) & gsPacket(rowTCP_FTIT2) & gsPacket(rowTCP_GearPos) & gsPacket(rowTCP_SpeedBrake) & gsPacket(rowTCP_EPUFuel) & _
    gsPacket(rowTCP_OilPressure) & gsPacket(rowTCP_OilPressure2) & gsPacket(rowTCP_LightBits) & gsPacket(rowTCP_HeadPitch) & gsPacket(rowTCP_HeadRoll) & _
    gsPacket(rowTCP_HeadYaw) & gsPacket(rowTCP_lightBits2) & gsPacket(rowTCP_lightBits3) & gsPacket(rowTCP_ChaffCount) & gsPacket(rowTCP_FlareCount) & _
    gsPacket(rowTCP_NoseGearPos) & gsPacket(rowTCP_LeftGearPos) & gsPacket(rowTCP_RightGearPos) & gsPacket(rowTCP_AdiIlsHorPos) & gsPacket(rowTCP_AdiIlsVerPos) & _
    gsPacket(rowTCP_courseState) & gsPacket(rowTCP_headingState) & gsPacket(rowTCP_totalStates) & gsPacket(rowTCP_courseDeviation) & gsPacket(rowTCP_desiredCourse) & _
    gsPacket(rowTCP_distanceToBeacon) & gsPacket(rowTCP_bearingToBeacon) & gsPacket(rowTCP_currentHeading) & gsPacket(rowTCP_desiredHeading) & gsPacket(rowTCP_deviationLimit) & _
    gsPacket(rowTCP_halfDeviationLimit) & gsPacket(rowTCP_localizerCourse) & gsPacket(rowTCP_airbaseX) & gsPacket(rowTCP_airbaseY) & gsPacket(rowTCP_totalValues) & _
    gsPacket(rowTCP_TrimPitch) & gsPacket(rowTCP_TrimRoll) & gsPacket(rowTCP_TrimYaw) & gsPacket(rowTCP_hsiBits) & gsPacket(rowTCP_DEDLines) & gsPacket(rowTCP_Invert) & _
    gsPacket(rowTCP_PFLLines) & gsPacket(rowTCP_PFLInvert) & gsPacket(rowTCP_UFCTChan) & gsPacket(rowTCP_AUXTChan) & gsPacket(rowTCP_RWRObjectCount) & _
    gsPacket(rowTCP_RWRSymbol) & gsPacket(rowTCP_Bearing) & gsPacket(rowTCP_MissileActivity) & gsPacket(rowTCP_MissileLaunch) & gsPacket(rowTCP_Selected) & _
    gsPacket(rowTCP_Lethality) & gsPacket(rowTCP_FWD) & gsPacket(rowTCP_AFT) & gsPacket(rowTCP_Total) & _
    gsPacket(rowTCP_LightBitsSet) & gsPacket(rowTCP_LightBits2Set) & gsPacket(rowTCP_LightBits3Set) & gsPacket(rowTCP_HSISet) & gsPacket(rowTCP_VersionNum) & gsPacket(rowTCP_FalconActive) & Chr(13)
'    gsPacket(rowTCP_VersionNum) & gsPacket(rowTCP_FalconActive)

   
  ' Send data to client Ports
  FnASock(mnSocket).SendData mvPacket
  DoEvents
  Exit Sub
  
FFDErr:
  MsgBox Err.Description & vbCr & "Generated by: BlowItOutYourTCPIPPort" & vbCr & "Source: " & Err.Source & "(" & Err.Number & ")", vbOKOnly, "Falcon-A Error"
  Exit Sub
    
End Sub

Private Sub YouAreTerminated()
  Dim mnCounter As Integer
  On Error Resume Next
  tmrF4Dat(tmrFlightData).Enabled = False
  UnmapViewOfFile (glPSharedMem)
  CloseHandle (ghSharedMem)                                        ' Close Shared Memory File
  If mnMaxSocket > 0 Then
    For mnCounter = 0 To mnMaxSocket
      FnASock_Close mnCounter
    Next mnCounter
  End If
  End
End Sub



Private Sub sldF4Dat_Click(index As Integer)

  With sldF4Dat(index)
    Select Case index
    Case sldFlightData
      tmrF4Dat(tmrFlightData).Interval = .Value
      lblF4Dat(lblF4TimerValue).Caption = .Value
    End Select
  End With
  
End Sub

Private Sub tmrF4Dat_Timer(index As Integer)
  ' Process Timer Events
  Dim mnCounter As Integer
  
  On Error GoTo F4DatError
  
  If Not gbFalconActive Then                                       ' Check for F4
    OpenF4SharedMemFile                                            ' Attempt to open Memory file
    Exit Sub
  End If
  
  Select Case index
  Case tmrFlightData
    Select Case gsFalconVersion
    Case "OF"
      CopyMemory FDOF, ByVal glPSharedMem, Len(FDOF)               ' Copy Shared Memory to OF Flight Data
    Case "BMS2"
      CopyMemory FDBMS2, ByVal glPSharedMem, Len(FDBMS2)           ' Copy Shared Memory to BMS 2.x Flight Data
    Case "AF"
      CopyMemory FDAF, ByVal glPSharedMem, Len(FDAF)               ' Copy Shared Memory to AF Flight Data
    End Select
  End Select
  
  DoEvents
  Exit Sub
  
F4DatError:
  mnErrorCounter = mnErrorCounter + 1
  MsgBox "Error: " & Err.Description & vbCr & "Has Occurred In Falcon-A", vbOKOnly, "Falcon-A Error Message"
  If mnErrorCounter = 5 Then YouAreTerminated

End Sub
