Attribute VB_Name = "F4Lib"
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Falcon-A Visual Basic Common Library
'
' 2004 - 2006 - Falcon-A Productions
'
' Adapted from code by Erwin Neyt - Eagle 9 Systems
' Thanks to those @ ViperPit.Org who helped and for Jeff "Ref" Owen's Input
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  Option Explicit
  
  Public Const SECTION_MAP_WRITE = &H2&
  Public Const SECTION_MAP_READ = &H4&
  Public Const FILE_MAP_WRITE = SECTION_MAP_WRITE
  Public Const FILE_MAP_READ = SECTION_MAP_READ

 
  Declare Function OpenFileMapping Lib "kernel32" Alias "OpenFileMappingA" (ByVal dwDesiredAccess As Long, ByVal bInheritHandle As Long, ByVal lpName As String) As Long
  Declare Function MapViewOfFile Lib "kernel32" (ByVal hFileMappingObject As Long, ByVal dwDesiredAccess As Long, ByVal dwFileOffsetHigh As Long, ByVal dwFileOffsetLow As Long, ByVal dwNumberOfBytesToMap As Long) As Long
  Declare Function UnmapViewOfFile Lib "kernel32" (lpBaseAddress As Any) As Long
  Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
  Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal numbytes As Long)
  Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
  Declare Function SendInput Lib "user32.dll" (ByVal nInputs As Long, pInputs As GENERALINPUT, ByVal cbSize As Long) As Long
  
  ' Various Memory Model Types
  Public FDOF As OFFlightData               ' Open Falcon Flight Data
  Public FDBMS2 As BMS2FlightData           ' BMS 2.x Flight Data
  Public FDAF As AFFlightData               ' Allied Force Flight Data
  
  Global gbFalconActive As Boolean          ' Falcon 4 Active Variable
  Global gsFalconVersion As String          ' Falcon Version (BMS & AF)
  
  
''' Flight Data Memory Models (OF, BMS 2.x & AF)

  ' MFD On Screen Button Labels(OF)
  Public Type OSBLabel
    Line1 As String * 8
    Line2 As String * 8
    Inverted As Boolean
  End Type

  ' Open Falcon Flight Data Model
  Public Type OFFlightData
    ShipNorth As Single                     ' Position of aircraft in North-South direction
    ShipEast As Single                      ' Position of aircraft in East-West direction
    ShipDown As Single                      ' Elevation of Aircraft
    ShipNorthRate As Single                 ' Velocity of Aircraft in North-South direction(ft/sec)
    ShipEastRate As Single                  ' Velocity of Aircraft in East-West direction (ft/sec)
    ShipDownRate As Single                  ' Rate of Descent/Climb
    Alpha As Single                         ' Ownship Angle of Attack (Degrees)
    Beta As Single                          ' Ownship Beta (Degrees)
    Gamma As Single                         ' Ownship Gamma (Radians)
    Pitch As Single                         ' Ownship Pitch Angle (Radians)
    Roll As Single                          ' Ownship Roll Angle (Radians)
    Yaw As Single                           ' Ownship Yaw Angle (Radians) (can also be used as magnetic heading)
    Mach As Single                          ' Ownship Mach number (Mach)
    KIAS As Single                          ' Ownship Indicated Airspeed (Knots)
    VT As Single                            ' Ownship True Airspeed (Ft/Sec)
    GS As Single                            ' Ownship G-Force (Gs)
    WindOffset As Single                    ' Wind delta to FPM (Radians)
    NozzlePos As Single                     ' Ownship engine nozzle percent open (0-100)
    InternalFuel As Single                  ' Ownship internal fuel (Lbs)
    ExternalFuel As Single                  ' Ownship external fuel (Lbs)
    FuelFlow As Single                      ' Ownship fuel flow (Lbs/Hour)
    RPM As Single                           ' Ownship engine rpm (Percent 0-103)
    FTIT As Single                          ' Ownship Forward Turbine Inlet Temp (Degrees C)
    GearPos As Single                       ' Ownship Gear position 0 = up, 1 = down;
    SpeedBrake As Single                    ' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
    EPUFuel As Single                       ' Ownship EPU fuel (Percent 0-100)
    OilPressure As Single                   ' Ownship Oil Pressure (Percent 0-100)
    LightBits As Long                       ' Cockpit Indicator Lights, one bit per bulb. See enum
    HeadPitch As Single                     ' Head pitch offset from design eye (radians)
    HeadRoll As Single                      ' Head roll offset from design eye (radians)
    HeadYaw As Single                       ' Head yaw offset from design eye (radians)
    LightBits2 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    LightBits3 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    ChaffCount As Single                    ' Number of Chaff left
    FlareCount As Single                    ' Number of Flare left
    NoseGearPos As Single                   ' Position of the nose landinggear
    LeftGearPos As Single                   ' Position of the left landinggear
    RightGearPos As Single                  ' Position of the right landinggear
    AdiIlsHorPos As Single                  ' Position of horizontal ILS bar
    AdiIlsVerPos As Single                  ' Position of vertical ILS bar
    CourseState As Long                     ' HSI_STA_CRS_STATE
    HeadingState As Long                    ' HSI_STA_HDG_STATE
    TotalStates As Long                     ' HSI_STA_TOTAL_STATES ???
    CourseDeviation  As Single              ' HSI_VAL_CRS_DEVIATION
    DesiredCourse As Single                 ' HSI_VAL_DESIRED_CRS
    DistanceToBeacon As Single              ' HSI_VAL_DISTANCE_TO_BEACON
    BearingToBeacon As Single               ' HSI_VAL_BEARING_TO_BEACON
    CurrentHeading As Single                ' HSI_VAL_CURRENT_HEADING
    DesiredHeading  As Single               ' HSI_VAL_DESIRED_HEADING
    DeviationLimit As Single                ' HSI_VAL_DEV_LIMIT
    HalfDeviationLimit As Single            ' HSI_VAL_HALF_DEV_LIMIT
    LocalizerCourse As Single               ' HSI_VAL_LOCALIZER_CRS
    AirBaseX As Single                      ' HSI_VAL_AIRBASE_X
    AirBaseY As Single                      ' HSI_VAL_AIRBASE_Y
    TotalValues As Single                   ' HSI_VAL_TOTAL_VALUES  ???
    TrimPitch As Single                     ' Value of trim in pitch axis, -0.5 to +0.5
    TrimRoll As Single                      ' Value of trim in roll axis, -0.5 to +0.5
    TrimYaw As Single                       ' Value of trim in yaw axis, -0.5 to +0.5
    HSIBits As Long                         ' HSI flags
    DEDLines As String * 130                ' DED 6 * 26 usable chars
    Invert As String * 130                  ' DED 6 * 26 usable chars
    PFLLines As String * 130                ' PFL 6 * 26 usable chars
    PFLInvert As String * 130               ' PFL 6 * 26 usable chars
    UFCTChan As Long                        ' UFC TACAN Channel
    AUXTChan  As Long                       ' AUX TACAN Channel
    RWRObjectCount  As Long                 ' Number of valid threat objects
    RWRSymbol(40) As Long                   ' Type of threat
    Bearing(40) As Single                   ' Bearing to threat (radians)
    MissileActivity(40) As Single           ' Missile is active or beam rider
    MissileLaunch(40) As Single             ' Missile is launched
    Selected(40) As Single                  ' Threat is Selected
    Lethality(40) As Single                 ' Lethal Range
    NewDetection(40) As Single              ' New Detection
    FWDFuel As Single                       ' Forward Fuel Tank Quantity
    AFTFuel As Single                       ' Aft Fuel Tank Quantity
    TotalFuel As Single                     ' Total Fuel Tank Quantity
    LightBitsSet As Long                    ' Light Bits Set
    LightBits2Set As Long                   ' Light Bits 2 Set
    LightBits3Set As Long                   ' Light Bits 3 Set
    HSISet As Long                          ' HSI Set
    VersionNum As Long                      ' Version of sh.mem file
'    LeftMFD(20) As OSBLabel                 ' Left MFD Labels
'    RightMFD(20) As OSBLabel                ' Right MFD Labels
  End Type


  ' BMS 2.x Flight Data Model
  Public Type BMS2FlightData
    ShipNorth As Single                     ' Position of aircraft in North-South direction
    ShipEast As Single                      ' Position of aircraft in East-West direction
    ShipDown As Single                      ' Elevation of Aircraft
    ShipNorthRate As Single                 ' Velocity of Aircraft in North-South direction(ft/sec)
    ShipEastRate As Single                  ' Velocity of Aircraft in East-West direction (ft/sec)
    ShipDownRate As Single                  ' Rate of Descent/Climb
    Alpha As Single                         ' Ownship Angle of Attack (Degrees)
    Beta As Single                          ' Ownship Beta (Degrees)
    Gamma As Single                         ' Ownship Gamma (Radians)
    Pitch As Single                         ' Ownship Pitch Angle (Radians)
    Roll As Single                          ' Ownship Roll Angle (Radians)
    Yaw As Single                           ' Ownship Yaw Angle (Radians) (can also be used as magnetic heading)
    Mach As Single                          ' Ownship Mach number (Mach)
    KIAS As Single                          ' Ownship Indicated Airspeed (Knots)
    VT As Single                            ' Ownship True Airspeed (Ft/Sec)
    GS As Single                            ' Ownship G-Force (Gs)
    WindOffset As Single                    ' Wind delta to FPM (Radians)
    NozzlePos As Single                     ' Ownship engine nozzle percent open (0-100)
    NozzlePos2 As Single                    ' Ownship engine nozzle2 percent open (0-100) - Multi-engine
    InternalFuel As Single                  ' Ownship internal fuel (Lbs)
    ExternalFuel As Single                  ' Ownship external fuel (Lbs)
    FuelFlow As Single                      ' Ownship fuel flow (Lbs/Hour)
    RPM As Single                           ' Ownship engine rpm (Percent 0-103)
    RPM2 As Single                          ' Ownship engine rpm2 (Percent 0-103) - multi-engine
    FTIT As Single                          ' Ownship Forward Turbine Inlet Temp (Degrees C)
    FTIT2 As Single                         ' Ownship Forward Turbine Inlet Temp2 (Degrees C) - multi-engine
    GearPos As Single                       ' Ownship Gear position 0 = up, 1 = down;
    SpeedBrake As Single                    ' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
    EPUFuel As Single                       ' Ownship EPU fuel (Percent 0-100)
    OilPressure As Single                   ' Ownship Oil Pressure (Percent 0-100)
    OilPressure2 As Single                  ' Ownship Oil Pressure2 (Percent 0-100)- Multi-engine
    LightBits As Long                       ' Cockpit Indicator Lights, one bit per bulb. See enum
    HeadPitch As Single                     ' Head pitch offset from design eye (radians)
    HeadRoll As Single                      ' Head roll offset from design eye (radians)
    HeadYaw As Single                       ' Head yaw offset from design eye (radians)
    LightBits2 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    LightBits3 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    ChaffCount As Single                    ' Number of Chaff left
    FlareCount As Single                    ' Number of Flare left
    NoseGearPos As Single                   ' Position of the nose landinggear
    LeftGearPos As Single                   ' Position of the left landinggear
    RightGearPos As Single                  ' Position of the right landinggear
    AdiIlsHorPos As Single                  ' Position of horizontal ILS bar
    AdiIlsVerPos As Single                  ' Position of vertical ILS bar
    CourseState As Long                     ' HSI_STA_CRS_STATE
    HeadingState As Long                    ' HSI_STA_HDG_STATE
    TotalStates As Long                     ' HSI_STA_TOTAL_STATES ???
    CourseDeviation  As Single              ' HSI_VAL_CRS_DEVIATION
    DesiredCourse As Single                 ' HSI_VAL_DESIRED_CRS
    DistanceToBeacon As Single              ' HSI_VAL_DISTANCE_TO_BEACON
    BearingToBeacon As Single               ' HSI_VAL_BEARING_TO_BEACON
    CurrentHeading As Single                ' HSI_VAL_CURRENT_HEADING
    DesiredHeading  As Single               ' HSI_VAL_DESIRED_HEADING
    DeviationLimit As Single                ' HSI_VAL_DEV_LIMIT
    HalfDeviationLimit As Single            ' HSI_VAL_HALF_DEV_LIMIT
    LocalizerCourse As Single               ' HSI_VAL_LOCALIZER_CRS
    AirBaseX As Single                      ' HSI_VAL_AIRBASE_X
    AirBaseY As Single                      ' HSI_VAL_AIRBASE_Y
    TotalValues As Single                   ' HSI_VAL_TOTAL_VALUES  ???
    TrimPitch As Single                     ' Value of trim in pitch axis, -0.5 to +0.5
    TrimRoll As Single                      ' Value of trim in roll axis, -0.5 to +0.5
    TrimYaw As Single                       ' Value of trim in yaw axis, -0.5 to +0.5
    HSIBits As Long                         ' HSI flags
    DEDLines As String * 130                ' DED 6 * 26 usable chars
    Invert As String * 130                  ' DED 6 * 26 usable chars
    PFLLines As String * 130                ' PFL 6 * 26 usable chars
    PFLInvert As String * 130               ' PFL 6 * 26 usable chars
    UFCTChan As Long                        ' UFC TACAN Channel
    AUXTChan  As Long                       ' AUX TACAN Channel
    RWRObjectCount  As Long                 ' Number of valid threat objects
    RWRSymbol(20) As Long                   ' Type of threat
    Bearing(20) As Single                   ' Bearing to threat (radians)
    MissileActivity(20) As Single           ' Missile is active or beam rider
    MissileLaunch(20) As Single             ' Missile is launched
    Selected(20) As Single                  ' Threat is Selected
    Lethality(20) As Single                 ' Lethal Range
    FWDFuel As Single                       ' Forward Fuel Tank Quantity
    AFTFuel As Single                       ' Aft Fuel Tank Quantity
    TotalFuel As Single                     ' Total Fuel Tank Quantity
    LightBitsSet As Long                    ' Light Bits Set
    LightBits2Set As Long                   ' Light Bits 2 Set
    LightBits3Set As Long                   ' Light Bits 3 Set
    HSISet As Long                          ' HSI Set
    VersionNum As Long                      ' Version of sh.mem file
  End Type
  
  
  ' Allied Force Flight Data Model
  Public Type AFFlightData
    ShipNorth As Single                     ' Position of aircraft in North-South direction
    ShipEast As Single                      ' Position of aircraft in East-West direction
    ShipDown As Single                      ' Elevation of Aircraft
    ShipNorthRate As Single                 ' Velocity of Aircraft in North-South direction(ft/sec)
    ShipEastRate As Single                  ' Velocity of Aircraft in East-West direction (ft/sec)
    ShipDownRate As Single                  ' Rate of Descent/Climb
    Alpha As Single                         ' Ownship Angle of Attack (Degrees)
    Beta As Single                          ' Ownship Beta (Degrees)
    Gamma As Single                         ' Ownship Gamma (Radians)
    Pitch As Single                         ' Ownship Pitch Angle (Radians)
    Roll As Single                          ' Ownship Roll Angle (Radians)
    Yaw As Single                           ' Ownship Yaw Angle (Radians) (can also be used as magnetic heading)
    Mach As Single                          ' Ownship Mach number (Mach)
    KIAS As Single                          ' Ownship Indicated Airspeed (Knots)
    VT As Single                            ' Ownship True Airspeed (Ft/Sec)
    GS As Single                            ' Ownship G-Force (Gs)
    WindOffset As Single                    ' Wind delta to FPM (Radians)
    NozzlePos As Single                     ' Ownship engine nozzle percent open (0-100)
    InternalFuel As Single                  ' Ownship internal fuel (Lbs)
    ExternalFuel As Single                  ' Ownship external fuel (Lbs)
    FuelFlow As Single                      ' Ownship fuel flow (Lbs/Hour)
    RPM As Single                           ' Ownship engine rpm (Percent 0-103)
    FTIT As Single                          ' Ownship Forward Turbine Inlet Temp (Degrees C)
    GearPos As Single                       ' Ownship Gear position 0 = up, 1 = down;
    SpeedBrake As Single                    ' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
    EPUFuel As Single                       ' Ownship EPU fuel (Percent 0-100)
    OilPressure As Single                   ' Ownship Oil Pressure (Percent 0-100)
    LightBits As Long                       ' Cockpit Indicator Lights, one bit per bulb. See enum
    HeadPitch As Single                     ' Head pitch offset from design eye (radians)
    HeadRoll As Single                      ' Head roll offset from design eye (radians)
    HeadYaw As Single                       ' Head yaw offset from design eye (radians)
    LightBits2 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    LightBits3 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    ChaffCount As Single                    ' Number of Chaff left
    FlareCount As Single                    ' Number of Flare left
    NoseGearPos As Single                   ' Position of the nose landinggear
    LeftGearPos As Single                   ' Position of the left landinggear
    RightGearPos As Single                  ' Position of the right landinggear
    AdiIlsHorPos As Single                  ' Position of horizontal ILS bar
    AdiIlsVerPos As Single                  ' Position of vertical ILS bar
    CourseState As Long                     ' HSI_STA_CRS_STATE
    HeadingState As Long                    ' HSI_STA_HDG_STATE
    TotalStates As Long                     ' HSI_STA_TOTAL_STATES ???
    CourseDeviation  As Single              ' HSI_VAL_CRS_DEVIATION
    DesiredCourse As Single                 ' HSI_VAL_DESIRED_CRS
    DistanceToBeacon As Single              ' HSI_VAL_DISTANCE_TO_BEACON
    BearingToBeacon As Single               ' HSI_VAL_BEARING_TO_BEACON
    CurrentHeading As Single                ' HSI_VAL_CURRENT_HEADING
    DesiredHeading  As Single               ' HSI_VAL_DESIRED_HEADING
    DeviationLimit As Single                ' HSI_VAL_DEV_LIMIT
    HalfDeviationLimit As Single            ' HSI_VAL_HALF_DEV_LIMIT
    LocalizerCourse As Single               ' HSI_VAL_LOCALIZER_CRS
    AirBaseX As Single                      ' HSI_VAL_AIRBASE_X
    AirBaseY As Single                      ' HSI_VAL_AIRBASE_Y
    TotalValues As Single                   ' HSI_VAL_TOTAL_VALUES  ???
    TrimPitch As Single                     ' Value of trim in pitch axis, -0.5 to +0.5
    TrimRoll As Single                      ' Value of trim in roll axis, -0.5 to +0.5
    TrimYaw As Single                       ' Value of trim in yaw axis, -0.5 to +0.5
    HSIBits As Long                         ' HSI flags
    DEDLines As String * 130                ' DED 6 * 26 usable chars
    Invert As String * 130                  ' DED 6 * 26 usable chars
    PFLLines As String * 130                ' PFL 6 * 26 usable chars
    PFLInvert As String * 130               ' PFL 6 * 26 usable chars
    UFCTChan As Long                        ' UFC TACAN Channel
    AUXTChan  As Long                       ' AUX TACAN Channel
    RWRObjectCount  As Long                 ' Number of valid threat objects
    RWRSymbol(40) As Long                   ' Type of threat
    Bearing(40) As Single                   ' Bearing to threat (radians)
    MissileActivity(40) As Single           ' Missile is active or beam rider
    MissileLaunch(40) As Single             ' Missile is launched
    Selected(40) As Single                  ' Threat is Selected
    Lethality(40) As Single                 ' Lethal Range
    NewDetection(40) As Single              ' New Detection
    FWDFuel As Single                       ' Forward Fuel Tank Quantity
    AFTFuel As Single                       ' Aft Fuel Tank Quantity
    TotalFuel As Single                     ' Total Fuel Tank Quantity
    LightBitsSet As Long                    ' Light Bits Set
    LightBits2Set As Long                   ' Light Bits 2 Set
    LightBits3Set As Long                   ' Light Bits 3 Set
    HSISet As Long                          ' HSI Set
    VersionNum As Long                      ' Version of sh.mem file
  End Type
  
' Keyboard Control Variables
  Global Const DIK_ESCAPE = &H1
  Global Const DIK_1 = &H2
  Global Const DIK_2 = &H3
  Global Const DIK_3 = &H4
  Global Const DIK_4 = &H5
  Global Const DIK_5 = &H6
  Global Const DIK_6 = &H7
  Global Const DIK_7 = &H8
  Global Const DIK_8 = &H9
  Global Const DIK_9 = &HA
  Global Const DIK_0 = &HB
  Global Const DIK_MINUS = &HC              '* - on main keyboard */
  Global Const DIK_EQUALS = &HD
  Global Const DIK_BACK = &HE               '* backspace */
  Global Const DIK_TAB = &HF
  Global Const DIK_Q = &H10
  Global Const DIK_W = &H11
  Global Const DIK_E = &H12
  Global Const DIK_R = &H13
  Global Const DIK_T = &H14
  Global Const DIK_Y = &H15
  Global Const DIK_U = &H16
  Global Const DIK_I = &H17
  Global Const DIK_O = &H18
  Global Const DIK_P = &H19
  Global Const DIK_LBRACKET = &H1A
  Global Const DIK_RBRACKET = &H1B
  Global Const DIK_RETURN = &H1C            '* Enter on main keyboard */
  Global Const DIK_LCONTROL = &H1D
  Global Const DIK_A = &H1E
  Global Const DIK_S = &H1F
  Global Const DIK_D = &H20
  Global Const DIK_F = &H21
  Global Const DIK_G = &H22
  Global Const DIK_H = &H23
  Global Const DIK_J = &H24
  Global Const DIK_K = &H25
  Global Const DIK_L = &H26
  Global Const DIK_SEMICOLON = &H27
  Global Const DIK_APOSTROPHE = &H28
  Global Const DIK_GRAVE = &H29             ' accent grave */
  Global Const DIK_LSHIFT = &H2A
  Global Const DIK_BACKSLASH = &H2B
  Global Const DIK_Z = &H2C
  Global Const DIK_X = &H2D
  Global Const DIK_C = &H2E
  Global Const DIK_V = &H2F
  Global Const DIK_B = &H30
  Global Const DIK_N = &H31
  Global Const DIK_M = &H32
  Global Const DIK_COMMA = &H33
  Global Const DIK_PERIOD = &H34            ' . on main keyboard */
  Global Const DIK_SLASH = &H35             ' / on main keyboard */
  Global Const DIK_RSHIFT = &H36
  Global Const DIK_MULTIPLY = &H37          ' * on numeric keypad */
  Global Const DIK_LMENU = &H38             ' left Alt */
  Global Const DIK_SPACE = &H39
  Global Const DIK_CAPITAL = &H3A
  Global Const DIK_F1 = &H3B
  Global Const DIK_F2 = &H3C
  Global Const DIK_F3 = &H3D
  Global Const DIK_F4 = &H3E
  Global Const DIK_F5 = &H3F
  Global Const DIK_F6 = &H40
  Global Const DIK_F7 = &H41
  Global Const DIK_F8 = &H42
  Global Const DIK_F9 = &H43
  Global Const DIK_F10 = &H44
  Global Const DIK_NUMLOCK = &H45
  Global Const DIK_SCROLL = &H46            ' Scroll Lock */
  Global Const DIK_NUMPAD7 = &H47
  Global Const DIK_NUMPAD8 = &H48
  Global Const DIK_NUMPAD9 = &H49
  Global Const DIK_SUBTRACT = &H4A          ' - on numeric keypad */
  Global Const DIK_NUMPAD4 = &H4B
  Global Const DIK_NUMPAD5 = &H4C
  Global Const DIK_NUMPAD6 = &H4D
  Global Const DIK_ADD = &H4E               ' + on numeric keypad */
  Global Const DIK_NUMPAD1 = &H4F
  Global Const DIK_NUMPAD2 = &H50
  Global Const DIK_NUMPAD3 = &H51
  Global Const DIK_NUMPAD0 = &H52
  Global Const DIK_DECIMAL = &H53           ' . on numeric keypad */
  Global Const DIK_F11 = &H57
  Global Const DIK_F12 = &H58
  Global Const DIK_F13 = &H64               '                     (NEC PC98) */
  Global Const DIK_F14 = &H65               '                     (NEC PC98) */
  Global Const DIK_F15 = &H66               '                     (NEC PC98) */
  Global Const DIK_KANA = &H70              ' (Japanese keyboard)            */
  Global Const DIK_CONVERT = &H79           ' (Japanese keyboard)            */
  Global Const DIK_NOCONVERT = &H7B         ' (Japanese keyboard)            */
  Global Const DIK_YEN = &H7D               ' (Japanese keyboard)            */
  Global Const DIK_NUMPADEQUALS = &H8D      ' = on numeric keypad (NEC PC98) */
  Global Const DIK_CIRCUMFLEX = &H90        ' (Japanese keyboard)            */
  Global Const DIK_AT = &H91                '                     (NEC PC98) */
  Global Const DIK_COLON = &H92             '                     (NEC PC98) */
  Global Const DIK_UNDERLINE = &H93         '                     (NEC PC98) */
  Global Const DIK_KANJI = &H94             ' (Japanese keyboard)            */
  Global Const DIK_STOP = &H95              '                     (NEC PC98) */
  Global Const DIK_AX = &H96                '                     (Japan AX) */
  Global Const DIK_UNLABELED = &H97         '                        (J3100) */
  Global Const DIK_NUMPADENTER = &H9C       ' Enter on numeric keypad */
  Global Const DIK_RCONTROL = &H9D
  Global Const DIK_NUMPADCOMMA = &HB3       ' , on numeric keypad (NEC PC98) */
  Global Const DIK_DIVIDE = &HB5            ' / on numeric keypad */
  Global Const DIK_SYSRQ = &HB7
  Global Const DIK_RMENU = &HB8             ' right Alt */
  Global Const DIK_PAUSE = &HC5             ' Pause */
  Global Const DIK_HOME = &HC7              ' Home on arrow keypad */
  Global Const DIK_UP = &HC8                ' UpArrow on arrow keypad */
  Global Const DIK_PRIOR = &HC9             ' PgUp on arrow keypad */
  Global Const DIK_LEFT = &HCB              ' LeftArrow on arrow keypad */
  Global Const DIK_RIGHT = &HCD             ' RightArrow on arrow keypad */
  Global Const DIK_END = &HCF               ' End on arrow keypad */
  Global Const DIK_DOWN = &HD0              ' DownArrow on arrow keypad */
  Global Const DIK_NEXT = &HD1              ' PgDn on arrow keypad */
  Global Const DIK_INSERT = &HD2            ' Insert on arrow keypad */
  Global Const DIK_DELETE = &HD3            ' Delete on arrow keypad */
  Global Const DIK_LWIN = &HDB              ' Left Windows key */
  Global Const DIK_RWIN = &HDC              ' Right Windows key */
  Global Const DIK_APPS = &HDD              ' AppMenu key */
  Global Const DIK_POWER = &HDE
  Global Const DIK_SLEEP = &HDF
  Global Const DIK_BACKSPACE = DIK_BACK                 ' backspace */
  Global Const DIK_NUMPADSTAR = DIK_MULTIPLY            ' * on numeric keypad */
  Global Const DIK_LALT = DIK_LMENU                     ' left Alt */
  Global Const DIK_CAPSLOCK = DIK_CAPITAL               ' CapsLock */
  Global Const DIK_NUMPADMINUS = DIK_SUBTRACT           ' - on numeric keypad */
  Global Const DIK_NUMPADPLUS = DIK_ADD                 ' + on numeric keypad */
  Global Const DIK_NUMPADPERIOD = DIK_DECIMAL           ' . on numeric keypad */
  Global Const DIK_NUMPADSLASH = DIK_DIVIDE             ' / on numeric keypad */
  Global Const DIK_RALT = DIK_RMENU                     ' right Alt */
  Global Const DIK_UPARROW = DIK_UP                     ' UpArrow on arrow keypad */
  Global Const DIK_PGUP = DIK_PRIOR                     ' PgUp on arrow keypad */
  Global Const DIK_LEFTARROW = DIK_LEFT                 ' LeftArrow on arrow keypad */
  Global Const DIK_RIGHTARROW = DIK_RIGHT               ' RightArrow on arrow keypad */
  Global Const DIK_DOWNARROW = DIK_DOWN                 ' DownArrow on arrow keypad */
  Global Const DIK_PGDN = DIK_NEXT                       ' PgDn on arrow keypad */
 

  Global Const WM_KEYUP = &H101
  Global Const WM_KEYDOWN = &H100
  Global Const VK_CONTROL = &H11
  Global Const VK_LCONTROL = &HA2
  Global Const vk_b = &H42
  Global Const vk_j = &H6A
  
  Global Const KEYEVENTF_KEYDOWN = &H0
  Global Const KEYEVENTF_KEYUP = &H2
  Global Const KEYEVENTF_SCANCODE = &H8
  Global Const KEYEVENTF_EXTENDEDKEY = &H1
  
  Global Const INPUT_MOUSE = 0
  Global Const INPUT_KEYBOARD = 1
  Global Const INPUT_HARDWARE = 2
  Global Const INPUT_GENERAL = 3

  Private Type MOUSEINPUT
    dx As Long
    dy As Long
    mouseData As Long
    dwFlags As Long
    time As Long
    dwExtraInfo As Long
  End Type
  Private Type KEYBDINPUT
    wVk As Integer
    wScan As Integer
    dwFlags As Long
    time As Long
    dwExtraInfo As Long
  End Type
  Private Type HARDWAREINPUT
    uMsg As Long
    wParamL As Integer
    wParamH As Integer
  End Type
  Private Type GENERALINPUT
    dwType As Long
    xi(0 To 23) As Byte
  End Type


Public Function SendKey(bKey0 As Byte, Optional bKey1 As Byte, Optional bKey2 As Byte, Optional bKey3 As Byte) As Integer
' Send Keystroke to Keyboard Buffer
' Big time thanks to Leo, Reff and Ghost for their help with this code
' Parameters: bKey  - Keyboard Key
'             vhState - Key State (default KEYEVENTF_SCANCODE)

  Dim GInput() As GENERALINPUT
  Dim KInput As KEYBDINPUT
  Dim mnCounter As Integer, mnTopEnd As Integer
  
  On Error GoTo SKErr
  
  If IsMissing(bKey1) Or bKey1 = 0 Then
    mnTopEnd = 0
  ElseIf IsMissing(bKey2) Or bKey2 = 0 Then
    mnTopEnd = 1
  ElseIf IsMissing(bKey3) Or bKey3 = 0 Then
    mnTopEnd = 2
  Else
    mnTopEnd = 3
  End If
  
  ReDim GInput(0 To mnTopEnd)
  ' Process Key-Down
  For mnCounter = 0 To mnTopEnd
    With KInput
      Select Case mnCounter
      Case 0
        .wScan = bKey0
      Case 1
        .wScan = bKey1
      Case 2
        .wScan = bKey2
      Case 3
        .wScan = bKey3
      Case Else
        DoEvents
      End Select
      .wVk = 0
      .dwFlags = KEYEVENTF_SCANCODE
      .time = 0
      .dwExtraInfo = 0
    End With
    GInput(mnCounter).dwType = INPUT_KEYBOARD                                        ' Keyboard Input
    CopyMemory GInput(mnCounter).xi(0), KInput, Len(KInput)    ' Copy KInput into the input array's buffer.
  Next mnCounter
  
  SendKey = SendInput(mnTopEnd + 1, GInput(0), Len(GInput(0)))
  
  mnCounter = 0
  ' Process Key-Up
  For mnCounter = mnTopEnd To 0 Step -1
    With KInput
      Select Case mnCounter
      Case 0
        .wVk = bKey0
        .wScan = bKey0
      Case 1
        .wVk = bKey1
        .wScan = bKey1
      Case 2
        .wVk = bKey2
        .wScan = bKey2
      Case 3
        .wVk = bKey3
        .wScan = bKey3
      Case Else
        DoEvents
      End Select
      .dwFlags = .dwFlags Or KEYEVENTF_KEYUP
      .time = 0
      .dwExtraInfo = 0
    End With
    GInput(mnCounter).dwType = INPUT_KEYBOARD                                        ' Keyboard Input
    CopyMemory GInput(mnCounter).xi(0), KInput, Len(KInput)    ' Copy KInput into the input array's buffer.
  Next mnCounter
  
  SendKey = SendInput(mnTopEnd + 1, GInput(0), Len(GInput(0)))

  DoEvents
  Exit Function

SKErr:
  DoEvents
  Resume Next
  
End Function


