VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFlightData"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Falcon 4 Shared Memory File Reader
'
' 2004 - 2006 - Team Banzai
'
' Adapted from code by Erwin "EagleEye" Neyt - Eagle 9 Systems
' Thanks to those @ ViperPit.Org who helped and for Jeff "Ref"'s Owen's Input
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'       Class: clsFlightData
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Description: Falcon BMS 2.x, Allied Force Memory Flight Data
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

  Option Explicit

  Private ofShipNorth As Single                     ' Ownship North (Ft)
  Private ofShipEast As Single                      ' Ownship East (Ft)
  Private ofShipDown As Single                      ' Ownship Down (Ft)
  Private ofShipNorthRate As Single                 ' Ownship North Rate (ft/sec)
  Private ofShipEastRate As Single                  ' Ownship East Rate (ft/sec)
  Private ofShipDownRate As Single                  ' Ownship Down Rate (ft/sec)
  Private ofAlpha As Single                         ' Ownship AOA (Degrees)
  Private ofBeta As Single                          ' Ownship Beta (Degrees)
  Private ofGamma As Single                         ' Ownship Gamma (Radians)
  Private ofPitch As Single                         ' Ownship Pitch (Radians)
  Private ofRoll As Single                          ' Ownship Roll (Radians)
  Private ofYaw As Single                           ' Ownship Yaw (Radians)
  Private ofMach As Single                          ' Ownship Mach number
  Private ofKIAS As Single                          ' Ownship Indicated Airspeed (Knots)
  Private ofVT As Single                            ' Ownship True Airspeed (Ft/Sec)
  Private ofGS As Single                            ' Ownship Normal Gs
  Private ofWindOffset As Single                    ' Wind delta to FPM (Radians)
  Private ofNozzlePos As Single                     ' Ownship engine nozzle percent open (0-100)
  Private ofNozzlePos2 As Single                    ' Ownship engine nozzle2 percent open (0-100) //TJL 01/14/04 Multi-engine
  Private ofInternalFuel As Single                  ' Ownship internal fuel (Lbs)
  Private ofExternalFuel As Single                  ' Ownship external fuel (Lbs)
  Private ofFuelFlow As Single                      ' Ownship fuel flow (Lbs/Hour)
  Private ofRPM As Single                           ' Ownship engine rpm (Percent 0-103)
  Private ofRPM2 As Single                          ' Ownship engine rpm2 (Percent 0-103) //TJL 01/14/04 multi-engine
  Private ofFTIT As Single                          ' Ownship Forward Turbine Inlet Temp (Degrees C)
  Private ofFTIT2 As Single                         ' Ownship Forward Turbine Inlet Temp2 (Degrees C)//TJL 01/14/04 multi-engine
  Private ofGearPos As Single                       ' Ownship Gear position 0 = up, 1 = down;
  Private ofSpeedBrake As Single                    ' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
  Private ofEPUFuel As Single                       ' Ownship EPU fuel (Percent 0-100)
  Private ofOilPressure As Single                   ' Ownship Oil Pressure (Percent 0-100)
  Private ofOilPressure2 As Single                  ' Ownship Oil Pressure2 (Percent 0-100)//TJL 01/14/04 Multi-engine
  Private onLightBits As Long                       ' Cockpit Indicator Lights, one bit per bulb. See enum
  Private ofHeadPitch As Single                     ' Head pitch offset from design eye (radians)
  Private ofHeadRoll As Single                      ' Head roll offset from design eye (radians)
  Private ofHeadYaw As Single                       ' Head yaw offset from design eye (radians)
  Private onLightBits2 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
  Private onLightBits3 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
  Private ofChaffCount As Single                    ' Number of Chaff left
  Private ofFlareCount As Single                    ' Number of Flare left
  Private ofNoseGearPos As Single                   ' Position of the nose landinggear
  Private ofLeftGearPos As Single                   ' Position of the left landinggear
  Private ofRightGearPos As Single                  ' Position of the right landinggear
  Private ofAdiIlsHorPos As Single                  ' Position of horizontal ILS bar
  Private ofAdiIlsVerPos As Single                  ' Position of vertical ILS bar
  Private onCourseState As Long                     ' HSI_STA_CRS_STATE
  Private onHeadingState As Long                    ' HSI_STA_HDG_STATE
  Private onTotalStates As Long                     ' HSI_STA_TOTAL_STATES ???
  Private ofCourseDeviation  As Single              ' HSI_VAL_CRS_DEVIATION
  Private ofDesiredCourse As Single                 ' HSI_VAL_DESIRED_CRS
  Private ofDistanceToBeacon As Single              ' HSI_VAL_DISTANCE_TO_BEACON
  Private ofBearingToBeacon As Single               ' HSI_VAL_BEARING_TO_BEACON
  Private ofCurrentHeading As Single                ' HSI_VAL_CURRENT_HEADING
  Private ofDesiredHeading  As Single               ' HSI_VAL_DESIRED_HEADING
  Private ofDeviationLimit As Single                ' HSI_VAL_DEV_LIMIT
  Private ofHalfDeviationLimit As Single            ' HSI_VAL_HALF_DEV_LIMIT
  Private ofLocalizerCourse As Single               ' HSI_VAL_LOCALIZER_CRS
  Private ofAirbaseX As Single                      ' HSI_VAL_AIRBASE_X
  Private ofAirbaseY As Single                      ' HSI_VAL_AIRBASE_Y
  Private ofTotalValues As Single                   ' HSI_VAL_TOTAL_VALUES  ???
  Private ofTrimPitch As Single                     ' Value of trim in pitch axis, -0.5 to +0.5
  Private ofTrimRoll As Single                      ' Value of trim in roll axis, -0.5 to +0.5
  Private ofTrimYaw As Single                       ' Value of trim in yaw axis, -0.5 to +0.5
  Private onHSIBits As Long                         ' HSI flags
  Private osDEDLines As String                      ' DED 6 * 26 usable chars
  Private osInvert As String                        ' DED 6 * 26 usable chars
  Private osPFLLines As String                      ' PFL 6 * 26 usable chars
  Private osPFLInvert As String                     ' PFL 6 * 26 usable chars
  Private onUFCTChan As Long                        ' UFC TACAN Channel
  Private onAUXTChan As Long                        ' AUX TACAN Channel
  Private onRWRObjectCount As Long                  ' Number of valid threat objects
  
  ' Seperate RWR Array size variables for different memory models
  'BMS 2.x
  Private onBMSRWRSymbol(20) As Long                   ' Type of Threat
  Private ofBMSBearing(20) As Single                   ' Bearing of Threat
  Private ofBMSMissileActivity(20) As Single           ' Missile is active or beam rider
  Private ofBMSMissileLaunch(20) As Single             ' Missile is Launched
  Private ofBMSSelected(20) As Single                  ' Threat is Selected
  Private ofBMSLethality(20) As Single                 ' Lethal Range
  
  'AF
  Private onAFRWRSymbol(40) As Long                 ' Type of Threat
  Private ofAFBearing(40) As Single                 ' Bearing of Threat
  Private ofAFMissileActivity(40) As Single         ' Missile is active or beam rider
  Private ofAFMissileLaunch(40) As Single           ' Missile is Launched
  Private ofAFSelected(40) As Single                ' Threat is Selected
  Private ofAFLethality(40) As Single               ' Lethal Range
  
  'OF
  Private onOFRWRSymbol(40) As Long                 ' Type of Threat
  Private ofOFBearing(40) As Single                 ' Bearing of Threat
  Private ofOFMissileActivity(40) As Single         ' Missile is active or beam rider
  Private ofOFMissileLaunch(40) As Single           ' Missile is Launched
  Private ofOFSelected(40) As Single                ' Threat is Selected
  Private ofOFLethality(40) As Single               ' Lethal Range
  
  
  Private ofFWDFuel As Single                       ' Forward fuel tank quantity
  Private ofAFTFuel As Single                       ' AFTFuel fuel tank quantity
  Private ofTotal As Single                         ' Total Fuel tank quantity
  Private onLightBitsSet As Long                    ' LightBits Set
  Private onLightBits2Set As Long                   ' LightBits2 Set
  Private onLightBits3Set As Long                   ' LightBits3 Set
  Private onHSISet As Long                          ' HSI Set
  Private onVersionNum As Long                      ' Version of sh.mem file
    
  Private obFalconAy As Boolean                     ' Falcon is Running
  Private osFalconVersion As String                 ' Falcon Version (BMS, AF, OF)
  
  ' MFD Labels
  Private osLeftMFDLabels(8) As OSBLabel            ' Left MFD Label
  Private osLeftMFDLine1(20)                        ' Breakdown of Left MFD Label
  Private osLeftMFDLine2(20)
  Private obLeftMFDInverted(20)
  
  Private osRightMFDLabels(8) As OSBLabel            ' Right MFD Label
  Private osRightMFDLine1(20)                        ' Breakdown of Right MFD Label
  Private osRightMFDLine2(20)
  Private obRightMFDInverted(20)


Public Property Let ShipNorth(vfSingle As Single)
' Own Ship North (Ft)
  ofShipNorth = vfSingle
End Property
Public Property Get ShipNorth() As Single
' Own Ship North (Ft)
  ShipNorth = ofShipNorth
End Property
Public Property Let ShipEast(vfSingle As Single)
' Own Ship East (Ft)
  ofShipEast = vfSingle
End Property
Public Property Get ShipEast() As Single
' Own Ship East (Ft)
  ShipEast = ofShipEast
End Property
Public Property Let ShipDown(vfSingle As Single)
' Own Ship Down (Ft)
  ofShipDown = vfSingle
End Property
Public Property Get ShipDown() As Single
' Own Ship Down (Ft)
  ShipDown = ofShipDown
End Property
Public Property Let ShipNorthRate(vfSingle As Single)
' Own Ship North Rate (Ft)
  ofShipNorthRate = vfSingle
End Property
Public Property Get ShipNorthRate() As Single
' Own Ship North Rate (Ft)
  ShipNorthRate = ofShipNorthRate
End Property
Public Property Let ShipEastRate(vfSingle As Single)
' Own Ship East Rate (Ft)
  ofShipEastRate = vfSingle
End Property
Public Property Get ShipEastRate() As Single
' Own Ship East Rate (Ft)
  ShipEastRate = ofShipEastRate
End Property
Public Property Let ShipDownRate(vfSingle As Single)
' Own Ship Down Rate (Ft)
  ofShipDownRate = vfSingle
End Property
Public Property Get ShipDownRate() As Single
' Own Ship Down Rate (Ft)
  ShipDownRate = ofShipDownRate
End Property
Public Property Let Alpha(vfSingle As Single)
' Own Ship Alpha - AOA
  ofAlpha = vfSingle
End Property
Public Property Get Alpha() As Single
' Own Ship Alpha - AOA
  Alpha = ofAlpha
End Property
Public Property Let Beta(vfSingle As Single)
' Own Ship Beta
  ofBeta = vfSingle
End Property
Public Property Get Beta() As Single
' Own Ship Beta
  Beta = ofBeta
End Property
Public Property Let Gamma(vfSingle As Single)
' Own Ship Gamma
  ofGamma = vfSingle
End Property
Public Property Get Gamma() As Single
' Own Ship Gamma
  Gamma = ofGamma
End Property
Public Property Let Pitch(vfSingle As Single)
' Own Ship Pitch
  ofPitch = vfSingle
End Property
Public Property Get Pitch() As Single
' Own Ship Pitch
  Pitch = ofPitch
End Property
Public Property Let Roll(vfSingle As Single)
' Own Ship Roll
  ofRoll = vfSingle
End Property
Public Property Get Roll() As Single
' Own Ship Roll
  Roll = ofRoll
End Property
Public Property Let Yaw(vfSingle As Single)
' Own Ship Yaw
  ofYaw = vfSingle
End Property
Public Property Get Yaw() As Single
' Own Ship Yaw
  Yaw = ofYaw
End Property
Public Property Let Mach(vfSingle As Single)
' Own Ship Mach
  ofMach = vfSingle
End Property
Public Property Get Mach() As Single
' Own Ship Mach
  Mach = ofMach
End Property
Public Property Let KIAS(vfSingle As Single)
' Own Ship KIAS
  ofKIAS = vfSingle
End Property
Public Property Get KIAS() As Single
' Own Ship KIAS
  KIAS = ofKIAS
End Property
Public Property Let VT(vfSingle As Single)
' Ownship True Airspeed (Ft/Sec)
  ofVT = vfSingle
End Property
Public Property Get VT() As Single
' Ownship True Airspeed (Ft/Sec)
  VT = ofVT
End Property
Public Property Let GS(vfSingle As Single)
' Own Ship Normal GS
  ofGS = vfSingle
End Property
Public Property Get GS() As Single
' Own Ship Normal GS
  GS = ofGS
End Property
Public Property Let WindOffset(vfSingle As Single)
' Wind delta to FPM (Radians)
  ofWindOffset = vfSingle
End Property
Public Property Get WindOffset() As Single
' Wind delta to FPM (Radians)
  WindOffset = ofWindOffset
End Property
Public Property Let NozzlePos(vfSingle As Single)
' Ownship engine nozzle percent open (0-100)
  ofNozzlePos = vfSingle
End Property
Public Property Get NozzlePos() As Single
' Ownship engine nozzle percent open (0-100)
  NozzlePos = ofNozzlePos
End Property
Public Property Let NozzlePos2(vfSingle As Single)
' Ownship engine nozzle2 percent open (0-100) //TJL 01/14/04 Multi-engine
  ofNozzlePos2 = vfSingle
End Property
Public Property Get NozzlePos2() As Single
' Ownship engine nozzle2 percent open (0-100) //TJL 01/14/04 Multi-engine
  NozzlePos2 = ofNozzlePos2
End Property
Public Property Let InternalFuel(vfSingle As Single)
' Ownship Internal Fuel (Lbs)
  ofInternalFuel = vfSingle
End Property
Public Property Get InternalFuel() As Single
' Ownship Internal Fuel (Lbs)
  InternalFuel = ofInternalFuel
End Property
Public Property Let ExternalFuel(vfSingle As Single)
' Ownship External Fuel (Lbs)
  ofExternalFuel = vfSingle
End Property
Public Property Get ExternalFuel() As Single
' Ownship External Fuel (Lbs)
  ExternalFuel = ofExternalFuel
End Property
Public Property Let FuelFlow(vfSingle As Single)
' Ownship fuel flow (Lbs/Hour)
  ofFuelFlow = vfSingle
End Property
Public Property Get FuelFlow() As Single
' Ownship fuel flow (Lbs/Hour)
  FuelFlow = ofFuelFlow
End Property
Public Property Let RPM(vfSingle As Single)
' Ownship RPM (Percent 0-103)
  ofRPM = vfSingle
End Property
Public Property Get RPM() As Single
' Ownship RPM (Percent 0-103)
  RPM = ofRPM
End Property
Public Property Let RPM2(vfSingle As Single)
' Ownship engine rpm2 (Percent 0-103) //TJL 01/14/04 multi-engine
  ofRPM2 = vfSingle
End Property
Public Property Get RPM2() As Single
' Ownship engine rpm2 (Percent 0-103) //TJL 01/14/04 multi-engine
  RPM2 = ofRPM2
End Property
Public Property Let FTIT(vfSingle As Single)
' Ownship Forward Turbine Inlet Temp (Degrees C)
  ofFTIT = vfSingle
End Property
Public Property Get FTIT() As Single
' Ownship Forward Turbine Inlet Temp (Degrees C)
  FTIT = ofFTIT
End Property
Public Property Let FTIT2(vfSingle As Single)
' Ownship Forward Turbine Inlet Temp2 (Degrees C)//TJL 01/14/04 multi-engine
  ofFTIT2 = vfSingle
End Property
Public Property Get FTIT2() As Single
' Ownship Forward Turbine Inlet Temp2 (Degrees C)//TJL 01/14/04 multi-engine
  FTIT2 = ofFTIT2
End Property
Public Property Let GearPos(vfSingle As Single)
' Ownship Gear position 0 = up, 1 = down;
  ofGearPos = vfSingle
End Property
Public Property Get GearPos() As Single
' Ownship Gear position 0 = up, 1 = down;
  GearPos = ofGearPos
End Property
Public Property Let SpeedBrake(vfSingle As Single)
' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
  ofSpeedBrake = vfSingle
End Property
Public Property Get SpeedBrake() As Single
' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
  SpeedBrake = ofSpeedBrake
End Property
Public Property Let EPUFuel(vfSingle As Single)
' Ownship EPU fuel (Percent 0-100)
  ofEPUFuel = vfSingle
End Property
Public Property Get EPUFuel() As Single
' Ownship EPU fuel (Percent 0-100)
  EPUFuel = ofEPUFuel
End Property
Public Property Let OilPressure(vfSingle As Single)
' Ownship Oil Pressure (Percent 0-100)
  ofOilPressure = vfSingle
End Property
Public Property Get OilPressure() As Single
' Ownship Oil Pressure (Percent 0-100)
  OilPressure = ofOilPressure
End Property
Public Property Let OilPressure2(vfSingle As Single)
' Ownship Oil Pressure2 (Percent 0-100)
  ofOilPressure2 = vfSingle
End Property
Public Property Get OilPressure2() As Single
' Ownship Oil Pressure2 (Percent 0-100)
  OilPressure2 = ofOilPressure2
End Property
Public Property Let LightBits(vnLong As Long)
' Cockpit Indicator Lights, one bit per bulb. See enum
  onLightBits = vnLong
End Property
Public Property Get LightBits() As Long
' Cockpit Indicator Lights, one bit per bulb. See enum
  LightBits = onLightBits
End Property
Public Property Let HeadPitch(vfSingle As Single)
' Own Ship Head Pitch
  ofHeadPitch = vfSingle
End Property
Public Property Get HeadPitch() As Single
' Own Ship Head Pitch
  HeadPitch = ofHeadPitch
End Property
Public Property Let HeadRoll(vfSingle As Single)
' Own Ship Head Roll
  ofHeadRoll = vfSingle
End Property
Public Property Get HeadRoll() As Single
' Own Ship HeadRoll
  HeadRoll = ofHeadRoll
End Property
Public Property Let HeadYaw(vfSingle As Single)
' Own Ship Head Yaw
  ofHeadYaw = vfSingle
End Property
Public Property Get HeadYaw() As Single
' Own Ship Head Yaw
  HeadYaw = ofHeadYaw
End Property
Public Property Let LightBits2(vnLong As Long)
' Cockpit Indicator Lights 2, one bit per bulb. See enum
  onLightBits2 = vnLong
End Property
Public Property Get LightBits2() As Long
' Cockpit Indicator Lights , one bit per bulb. See enum
  LightBits2 = onLightBits2
End Property
Public Property Let LightBits3(vnLong As Long)
' Cockpit Indicator Lights 3, one bit per bulb. See enum
  onLightBits3 = vnLong
End Property
Public Property Get LightBits3() As Long
' Cockpit Indicator Lights , one bit per bulb. See enum
  LightBits3 = onLightBits3
End Property
Public Property Let ChaffCount(vfSingle As Single)
' Own Ship Chaff Count
  ofChaffCount = vfSingle
End Property
Public Property Get ChaffCount() As Single
' Own Ship Chaff Count
  ChaffCount = ofChaffCount
End Property
Public Property Let FlareCount(vfSingle As Single)
' Own Ship Flare Count
  ofFlareCount = vfSingle
End Property
Public Property Get FlareCount() As Single
' Own Ship Flare Count
  FlareCount = ofFlareCount
End Property
Public Property Let NoseGearPos(vfSingle As Single)
' Position of the Nose Landing Gear
  ofNoseGearPos = vfSingle
End Property
Public Property Get NoseGearPos() As Single
' Position of the Nose Landing Gear
  NoseGearPos = ofNoseGearPos
End Property
Public Property Let LeftGearPos(vfSingle As Single)
' Position of the Left Landing Gear
  ofLeftGearPos = vfSingle
End Property
Public Property Get LeftGearPos() As Single
' Position of the Left Landing Gear
  LeftGearPos = ofLeftGearPos
End Property
Public Property Let RightGearPos(vfSingle As Single)
' Position of the Right Landing Gear
  ofRightGearPos = vfSingle
End Property
Public Property Get RightGearPos() As Single
' Position of the Right Landing Gear
  RightGearPos = ofRightGearPos
End Property
Public Property Let AdiIlsHorPos(vfSingle As Single)
' Position of Horizontal ILS bar
  ofAdiIlsHorPos = vfSingle
End Property
Public Property Get AdiIlsHorPos() As Single
' Position of Horizontal ILS bar
  ofAdiIlsHorPos = ofAdiIlsHorPos
End Property
Public Property Let AdiIlsVerPos(vfSingle As Single)
' Position of Vertical ILS bar
  AdiIlsVerPos = vfSingle
End Property
Public Property Get AdiIlsVerPos() As Single
' Position of Vertical ILS bar
  AdiIlsVerPos = ofAdiIlsVerPos
End Property
Public Property Let CourseState(vnLong As Long)
' Course State - HSI_STA_CRS_STATE
  onCourseState = vnLong
End Property
Public Property Get CourseState() As Long
' Course State - HSI_STA_CRS_STATE
  CourseState = onCourseState
End Property
Public Property Let HeadingState(vnLong As Long)
' Heading State - HSI_STA_HDG_STATE
  onHeadingState = vnLong
End Property
Public Property Get HeadingState() As Long
' Heading State - HSI_STA_HDG_STATE
  HeadingState = onHeadingState
End Property
Public Property Let TotalStates(vnLong As Long)
' Total States - HSI_STA_TOTAL_STATES
  onTotalStates = vnLong
End Property
Public Property Get TotalStates() As Long
' Total States - HSI_STA_TOTAL_STATES
  TotalStates = onTotalStates
End Property
Public Property Let CourseDeviation(vfSingle As Single)
' Course Deviation - HSI_VAL_CRS_DEVIATION
  ofCourseDeviation = vfSingle
End Property
Public Property Get CourseDeviation() As Single
' Course Deviation - HSI_VAL_CRS_DEVIATION
  CourseDeviation = ofCourseDeviation
End Property
Public Property Let DesiredCourse(vfSingle As Single)
' Desired Course - HSI_VAL_DESIRED_CRS
  ofDesiredCourse = vfSingle
End Property
Public Property Get DesiredCourse() As Single
' Desired Course - HSI_VAL_DESIRED_CRS
  DesiredCourse = ofDesiredCourse
End Property
Public Property Let DistanceToBeacon(vfSingle As Single)
' Distance To Beacon - HSI_VAL_DISTANCE_TO_BEACON
  ofDistanceToBeacon = vfSingle
End Property
Public Property Get DistanceToBeacon() As Single
' Distance To Beacon - HSI_VAL_DISTANCE_TO_BEACON
  DistanceToBeacon = ofDistanceToBeacon
End Property
Public Property Let BearingToBeacon(vfSingle As Single)
' Bearing To Beacon - HSI_VAL_BEARING_TO_BEACON
  ofBearingToBeacon = vfSingle
End Property
Public Property Get BearingToBeacon() As Single
' Bearing To Beacon - HSI_VAL_BEARING_TO_BEACON
  BearingToBeacon = ofBearingToBeacon
End Property
Public Property Let CurrentHeading(vfSingle As Single)
' Ownship Current Heading - HSI_VAL_CURRENT_HEADING
  ofCurrentHeading = vfSingle
End Property
Public Property Get CurrentHeading() As Single
' Ownship Current Heading - HSI_VAL_CURRENT_HEADING
  CurrentHeading = ofCurrentHeading
End Property
Public Property Let DesiredHeading(vfSingle As Single)
' Ownship Desired Heading - HSI_VAL_DESIRED_HEADING
  ofDesiredHeading = vfSingle
End Property
Public Property Get DesiredHeading() As Single
' Ownship Desired Heading - HSI_VAL_DESIRED_HEADING
  DesiredHeading = ofDesiredHeading
End Property
Public Property Let DeviationLimit(vfSingle As Single)
' Ownship Deviation Limit - HSI_VAL_DEV_LIMIT
  ofDeviationLimit = vfSingle
End Property
Public Property Get DeviationLimit() As Single
' Ownship Deviation Limit - HSI_VAL_DEV_LIMIT
  DeviationLimit = ofDeviationLimit
End Property
Public Property Let HalfDeviationLimit(vfSingle As Single)
' Ownship Half Deviation Limit - HSI_VAL_HALF_DEV_LIMIT
  ofHalfDeviationLimit = vfSingle
End Property
Public Property Get HalfDeviationLimit() As Single
' Ownship Half Deviation Limit - HSI_VAL_HALF_DEV_LIMIT
  HalfDeviationLimit = ofHalfDeviationLimit
End Property
Public Property Let LocalizerCourse(vfSingle As Single)
' Localizer Course - HSI_VAL_LOCALIZER_CRS
  ofLocalizerCourse = vfSingle
End Property
Public Property Get LocalizerCourse() As Single
' Localizer Course - HSI_VAL_LOCALIZER_CRS
  LocalizerCourse = ofLocalizerCourse
End Property
Public Property Let AirBaseX(vfSingle As Single)
' AirBase X - HSI_VAL_AIRBASE_X
  ofAirbaseX = vfSingle
End Property
Public Property Get AirBaseX() As Single
' AirBase X - HSI_VAL_AIRBASE_X
  AirBaseX = ofAirbaseX
End Property
Public Property Let AirBaseY(vfSingle As Single)
' AirBase Y - HSI_VAL_AIRBASE_Y
  ofAirbaseY = vfSingle
End Property
Public Property Get AirBaseY() As Single
' AirBase Y - HSI_VAL_AIRBASE_Y
  AirBaseY = ofAirbaseY
End Property
Public Property Let TotalValues(vfSingle As Single)
' HSI_VAL_TOTAL_VALUES
  ofTotalValues = vfSingle
End Property
Public Property Get TotalValues() As Single
' HSI_VAL_TOTAL_VALUES
  TotalValues = ofTotalValues
End Property
Public Property Let TrimPitch(vfSingle As Single)
' Value of trim in Pitch axis, -0.5 to +0.5
  ofTrimPitch = vfSingle
End Property
Public Property Get TrimPitch() As Single
' Value of trim in Pitch axis, -0.5 to +0.5
  TrimPitch = ofTrimPitch
End Property
Public Property Let TrimRoll(vfSingle As Single)
' Value of trim in Roll axis, -0.5 to +0.5
  ofTrimRoll = vfSingle
End Property
Public Property Get TrimRoll() As Single
' Value of trim in Roll axis, -0.5 to +0.5
  TrimRoll = ofTrimRoll
End Property
Public Property Let TrimYaw(vfSingle As Single)
' Value of trim in Yaw axis, -0.5 to +0.5
  ofTrimYaw = vfSingle
End Property
Public Property Get TrimYaw() As Single
' Value of trim in Yaw axis, -0.5 to +0.5
  TrimYaw = ofTrimYaw
End Property
Public Property Let HSIBits(vnLong As Long)
' HSI flags
  onHSIBits = vnLong
End Property
Public Property Get HSIBits() As Long
' HSI flags
  HSIBits = onHSIBits
End Property
Public Property Let DEDLines(vsString As String)
' DED 25 usable chars
  osDEDLines = vsString
End Property
Public Property Get DEDLines() As String
' DED 25 usable chars
  DEDLines = osDEDLines
End Property
Public Property Let Invert(vsString As String)
' DED 25 usable chars
  osInvert = vsString
End Property
Public Property Get Invert() As String
' DED 25 usable chars
  Invert = osInvert
End Property
Public Property Let PFLLines(vsString As String)
' PFL 25 usable chars
  osPFLLines = vsString
End Property
Public Property Get PFLLines() As String
' PFL 25 usable chars
  PFLLines = osPFLLines
End Property
Public Property Let PFLInvert(vsString As String)
' PFL 25 usable chars
  osPFLInvert = vsString
End Property
Public Property Get PFLInvert() As String
' PFL 25 usable chars
  PFLInvert = osPFLInvert
End Property
Public Property Let FalconAy(vbBoolean As Boolean)
' Falcon Running
  'onFalconAy = vnBoolean
End Property
Public Property Get FalconAy() As Boolean
' Falcon Running
  FalconAy = gbFalconActive
End Property
Public Property Let FalconVersion(vsString As String)
' Falcon Version (BMS, AF)
  'osFalconVersion = vsString
End Property
Public Property Get FalconVersion() As String
' Falcon Version (BMS, AF, OF)
  FalconVersion = gsFalconVersion
End Property

Public Property Let UFCTChan(vfLong As Long)
' UFC TACAN Channel
  onUFCTChan = vfLong
End Property
Public Property Get UFCTChan() As Long
' UFC TACAN Channel
  UFCTChan = onUFCTChan
End Property
Public Property Let AUXTChan(vfLong As Long)
' AUX TACAN Channel
  onAUXTChan = vfLong
End Property
Public Property Get AUXTChan() As Long
' AUX TACAN Channel
  AUXTChan = onAUXTChan
End Property
Public Property Let RWRObjectCount(vnLong As Long)
' Number of valid threat objects
  onRWRObjectCount = vnLong
End Property
Public Property Get RWRObjectCount() As Long
' Number of valid threat objects
  RWRObjectCount = onRWRObjectCount
End Property
Public Property Let FWDFuel(vfSingle As Single)
' Forward Fuel Tank Quantity
  ofFWDFuel = vfSingle
End Property
Public Property Get FWDFuel() As Single
' Forward Fuel Tank Quantity
  FWDFuel = ofFWDFuel
End Property
Public Property Let AFTFuel(vfSingle As Single)
' AFTFuel Fuel Tank Quantity
  ofAFTFuel = vfSingle
End Property
Public Property Get AFTFuel() As Single
' AFTFuel Fuel Tank Quantity
  AFTFuel = ofAFTFuel
End Property
Public Property Let Total(vfSingle As Single)
' Total Fuel Tank Quantity
  ofTotal = vfSingle
End Property
Public Property Get Total() As Single
' Total Fuel Tank Quantity
  Total = ofTotal
End Property
Public Property Let LightBitsSet(vfLong As Long)
' Light Bits Set
  onLightBitsSet = vfLong
End Property
Public Property Get LightBitsSet() As Long
' Light Bits Set
  LightBitsSet = onLightBitsSet
End Property
Public Property Let LightBits2Set(vfLong As Long)
' Light Bits 2 Set
  onLightBits2Set = vfLong
End Property
Public Property Get LightBits2Set() As Long
' Light Bits 2 Set
  LightBits2Set = onLightBits2Set
End Property
Public Property Let LightBits3Set(vfLong As Long)
' Light Bits 3 Set
  onLightBits3Set = vfLong
End Property
Public Property Get LightBits3Set() As Long
' Light Bits 3 Set
  LightBits3Set = onLightBits3Set
End Property
Public Property Let HSISet(vfLong As Long)
' Light Bits Set
  onHSISet = vfLong
End Property
Public Property Get HSISet() As Long
' Light Bits Set
  HSISet = onHSISet
End Property
Public Property Let VersionNum(vfLong As Long)
' Version of sh.mem file
  onVersionNum = vfLong
End Property
Public Property Get VersionNum() As Long
' Version of sh.mem file
  VersionNum = onVersionNum
End Property

Public Property Let ClassDescription(vsText As String)
' Class Description
End Property
Public Property Get ClassDescription() As String
' Class Description
  ClassDescription = "FlightData"
End Property

Public Sub FillFlightData()
' Populate Flight Data Variables from Shared Memory
' Determine Memory
Dim mnCounter As Integer
On Error GoTo FFDErr

  Select Case gsFalconVersion                                      ' Determine Model to Use
  Case "OF"                                                        ' Open Falcon Memory Model
    With FDOF
      ofShipNorth = .ShipNorth
      ofShipEast = .ShipEast
      ofShipDown = .ShipDown
      ofShipNorthRate = .ShipNorthRate
      ofShipEastRate = .ShipEastRate
      ofShipDownRate = .ShipDownRate
      ofAlpha = .Alpha
      ofBeta = .Beta
      ofGamma = .Gamma
      ofPitch = .Pitch
      ofRoll = .Roll
      ofYaw = .Yaw
      ofMach = .Mach
      ofKIAS = .KIAS
      ofVT = .VT
      ofGS = .GS
      ofWindOffset = .WindOffset
      ofNozzlePos = .NozzlePos
      ofNozzlePos2 = 0
      ofInternalFuel = .InternalFuel
      ofExternalFuel = .ExternalFuel
      ofFuelFlow = .FuelFlow
      ofRPM = .RPM
      ofRPM2 = 0
      ofFTIT = .FTIT
      ofFTIT2 = 0
      ofGearPos = .GearPos
      ofSpeedBrake = .SpeedBrake
      ofEPUFuel = .EPUFuel
      ofOilPressure = .OilPressure
      ofOilPressure2 = 0
      onLightBits = .LightBits
      ofHeadPitch = .HeadPitch
      ofHeadRoll = .HeadRoll
      ofHeadYaw = .HeadYaw
      onLightBits2 = .LightBits2
      onLightBits3 = .LightBits3
      ofChaffCount = .ChaffCount
      ofFlareCount = .FlareCount
      ofNoseGearPos = .NoseGearPos
      ofLeftGearPos = .LeftGearPos
      ofRightGearPos = .RightGearPos
      ofAdiIlsHorPos = .AdiIlsHorPos
      ofAdiIlsVerPos = .AdiIlsVerPos
      onCourseState = .CourseState
      onHeadingState = .HeadingState
      onTotalStates = .TotalStates
      ofCourseDeviation = .CourseDeviation
      ofDesiredCourse = .DesiredCourse
      ofDistanceToBeacon = .DistanceToBeacon
      ofBearingToBeacon = .BearingToBeacon
      ofCurrentHeading = .CurrentHeading
      ofDesiredHeading = .DesiredHeading
      ofDeviationLimit = .DeviationLimit
      ofHalfDeviationLimit = .HalfDeviationLimit
      ofLocalizerCourse = .LocalizerCourse
      ofAirbaseX = .AirBaseX
      ofAirbaseY = .AirBaseY
      ofTotalValues = .TotalValues
      ofTrimPitch = .TrimPitch
      ofTrimRoll = .TrimRoll
      ofTrimYaw = .TrimYaw
      onHSIBits = .HSIBits
      osDEDLines = .DEDLines
      osInvert = .Invert
      osPFLLines = .PFLLines
      osPFLInvert = .PFLInvert
      onUFCTChan = .UFCTChan
      onAUXTChan = .AUXTChan
      onRWRObjectCount = .RWRObjectCount
      ' Build Array Data for Symbol, Bearing, MissileActivity, MissileLaunch, Selected, Lethality
      For mnCounter = LBound(ofOFBearing) To UBound(ofOFBearing)
        onOFRWRSymbol(mnCounter) = .RWRSymbol(mnCounter)
        ofOFBearing(mnCounter) = .Bearing(mnCounter)
        ofOFMissileActivity(mnCounter) = .MissileActivity(mnCounter)
        ofOFMissileLaunch(mnCounter) = .MissileLaunch(mnCounter)
        ofOFSelected(mnCounter) = .Selected(mnCounter)
        ofOFLethality(mnCounter) = .Lethality(mnCounter)
      Next mnCounter
      
      ofFWDFuel = .FWDFuel
      ofAFTFuel = .AFTFuel
      ofTotal = .TotalFuel
      onLightBitsSet = .LightBitsSet
      onLightBits2Set = .LightBits2Set
      onLightBits3Set = .LightBits3Set
      onVersionNum = .VersionNum
      ' MFD Labels (if ever implemented)
'      For mnCounter = 0 To 19
'        osLeftMFDLine1(mnCounter) = .LeftMFD(mnCounter).Line1
'        osLeftMFDLine2(mnCounter) = .LeftMFD(mnCounter).Line2
'        obLeftMFDInverted(mnCounter) = .LeftMFD(mnCounter).Inverted
'
'        osRightMFDLine1(mnCounter) = .RightMFD(mnCounter).Line1
'        osRightMFDLine2(mnCounter) = .RightMFD(mnCounter).Line2
'        obRightMFDInverted(mnCounter) = .RightMFD(mnCounter).Inverted
'
'        'Debug.Print mnCounter & " - *" & osLeftMFDLine1(mnCounter) & "*     *" & osLeftMFDLine2(mnCounter) & "*     *" & obLeftMFDInverted(mnCounter) & "*"
'        'Debug.Print mnCounter & " - *" & osRightMFDLine1(mnCounter) & "*     *" & osRightMFDLine2(mnCounter) & "*     *" & obRightMFDInverted(mnCounter) & "*"
'
'      Next mnCounter
    End With
  
  Case "BMS2"                                                       ' BMS Memory Model
    With FDBMS2
      ofShipNorth = .ShipNorth
      ofShipEast = .ShipEast
      ofShipDown = .ShipDown
      ofShipNorthRate = .ShipNorthRate
      ofShipEastRate = .ShipEastRate
      ofShipDownRate = .ShipDownRate
      ofAlpha = .Alpha
      ofBeta = .Beta
      ofGamma = .Gamma
      ofPitch = .Pitch
      ofRoll = .Roll
      ofYaw = .Yaw
      ofMach = .Mach
      ofKIAS = .KIAS
      ofVT = .VT
      ofGS = .GS
      ofWindOffset = .WindOffset
      ofNozzlePos = .NozzlePos
      ofNozzlePos2 = .NozzlePos2
      ofInternalFuel = .InternalFuel
      ofExternalFuel = .ExternalFuel
      ofFuelFlow = .FuelFlow
      ofRPM = .RPM
      ofRPM2 = .RPM2
      ofFTIT = .FTIT
      ofFTIT2 = .FTIT2
      ofGearPos = .GearPos
      ofSpeedBrake = .SpeedBrake
      ofEPUFuel = .EPUFuel
      ofOilPressure = .OilPressure
      ofOilPressure2 = .OilPressure2
      onLightBits = .LightBits
      ofHeadPitch = .HeadPitch
      ofHeadRoll = .HeadRoll
      ofHeadYaw = .HeadYaw
      onLightBits2 = .LightBits2
      onLightBits3 = .LightBits3
      ofChaffCount = .ChaffCount
      ofFlareCount = .FlareCount
      ofNoseGearPos = .NoseGearPos
      ofLeftGearPos = .LeftGearPos
      ofRightGearPos = .RightGearPos
      ofAdiIlsHorPos = .AdiIlsHorPos
      ofAdiIlsVerPos = .AdiIlsVerPos
      onCourseState = .CourseState
      onHeadingState = .HeadingState
      onTotalStates = .TotalStates
      ofCourseDeviation = .CourseDeviation
      ofDesiredCourse = .DesiredCourse
      ofDistanceToBeacon = .DistanceToBeacon
      ofBearingToBeacon = .BearingToBeacon
      ofCurrentHeading = .CurrentHeading
      ofDesiredHeading = .DesiredHeading
      ofDeviationLimit = .DeviationLimit
      ofHalfDeviationLimit = .HalfDeviationLimit
      ofLocalizerCourse = .LocalizerCourse
      ofAirbaseX = .AirBaseX
      ofAirbaseY = .AirBaseY
      ofTotalValues = .TotalValues
      ofTrimPitch = .TrimPitch
      ofTrimRoll = .TrimRoll
      ofTrimYaw = .TrimYaw
      onHSIBits = .HSIBits
      osDEDLines = .DEDLines
      osInvert = .Invert
      osPFLLines = .PFLLines
      osPFLInvert = .PFLInvert
      onUFCTChan = .UFCTChan
      onAUXTChan = .AUXTChan
      onRWRObjectCount = .RWRObjectCount
      ' Build Array Data for Symbol, Bearing, MissileActivity, MissileLaunch, Selected, Lethality
      For mnCounter = LBound(ofBMSBearing) To UBound(ofBMSBearing)
        onBMSRWRSymbol(mnCounter) = .RWRSymbol(mnCounter)
        ofBMSBearing(mnCounter) = .Bearing(mnCounter)
        ofBMSMissileActivity(mnCounter) = .MissileActivity(mnCounter)
        ofBMSMissileLaunch(mnCounter) = .MissileLaunch(mnCounter)
        ofBMSSelected(mnCounter) = .Selected(mnCounter)
        ofBMSLethality(mnCounter) = .Lethality(mnCounter)
      Next mnCounter
      
      ofFWDFuel = .FWDFuel
      ofAFTFuel = .AFTFuel
      ofTotal = .TotalFuel
      onLightBitsSet = .LightBitsSet
      onLightBits2Set = .LightBits2Set
      onLightBits3Set = .LightBits3Set
      onVersionNum = .VersionNum
    End With
    
  Case "AF"                                                        ' Allied Force Memory Model
    With FDAF
      ofShipNorth = .ShipNorth
      ofShipEast = .ShipEast
      ofShipDown = .ShipDown
      ofShipNorthRate = .ShipNorthRate
      ofShipEastRate = .ShipEastRate
      ofShipDownRate = .ShipDownRate
      ofAlpha = .Alpha
      ofBeta = .Beta
      ofGamma = .Gamma
      ofPitch = .Pitch
      ofRoll = .Roll
      ofYaw = .Yaw
      ofMach = .Mach
      ofKIAS = .KIAS
      ofVT = .VT
      ofGS = .GS
      ofWindOffset = .WindOffset
      ofNozzlePos = .NozzlePos
      ofNozzlePos2 = 0
      ofInternalFuel = .InternalFuel
      ofExternalFuel = .ExternalFuel
      ofFuelFlow = .FuelFlow
      ofRPM = .RPM
      ofRPM2 = 0
      ofFTIT = .FTIT
      ofFTIT2 = 0
      ofGearPos = .GearPos
      ofSpeedBrake = .SpeedBrake
      ofEPUFuel = .EPUFuel
      ofOilPressure = .OilPressure
      ofOilPressure2 = 0
      onLightBits = .LightBits
      ofHeadPitch = .HeadPitch
      ofHeadRoll = .HeadRoll
      ofHeadYaw = .HeadYaw
      onLightBits2 = .LightBits2
      onLightBits3 = .LightBits3
      ofChaffCount = .ChaffCount
      ofFlareCount = .FlareCount
      ofNoseGearPos = .NoseGearPos
      ofLeftGearPos = .LeftGearPos
      ofRightGearPos = .RightGearPos
      ofAdiIlsHorPos = .AdiIlsHorPos
      ofAdiIlsVerPos = .AdiIlsVerPos
      onCourseState = .CourseState
      onHeadingState = .HeadingState
      onTotalStates = .TotalStates
      ofCourseDeviation = .CourseDeviation
      ofDesiredCourse = .DesiredCourse
      ofDistanceToBeacon = .DistanceToBeacon
      ofBearingToBeacon = .BearingToBeacon
      ofCurrentHeading = .CurrentHeading
      ofDesiredHeading = .DesiredHeading
      ofDeviationLimit = .DeviationLimit
      ofHalfDeviationLimit = .HalfDeviationLimit
      ofLocalizerCourse = .LocalizerCourse
      ofAirbaseX = .AirBaseX
      ofAirbaseY = .AirBaseY
      ofTotalValues = .TotalValues
      ofTrimPitch = .TrimPitch
      ofTrimRoll = .TrimRoll
      ofTrimYaw = .TrimYaw
      onHSIBits = .HSIBits
      osDEDLines = .DEDLines
      osInvert = .Invert
      osPFLLines = .PFLLines
      osPFLInvert = .PFLInvert
      onUFCTChan = .UFCTChan
      onAUXTChan = .AUXTChan
      onRWRObjectCount = .RWRObjectCount
      ' Build Array Data for Symbol, Bearing, MissileActivity, MissileLaunch, Selected, Lethality
      For mnCounter = LBound(ofAFBearing) To UBound(ofAFBearing)
        onAFRWRSymbol(mnCounter) = .RWRSymbol(mnCounter)
        ofAFBearing(mnCounter) = .Bearing(mnCounter)
        ofAFMissileActivity(mnCounter) = .MissileActivity(mnCounter)
        ofAFMissileLaunch(mnCounter) = .MissileLaunch(mnCounter)
        ofAFSelected(mnCounter) = .Selected(mnCounter)
        ofAFLethality(mnCounter) = .Lethality(mnCounter)
      Next mnCounter
      
      ofFWDFuel = .FWDFuel
      ofAFTFuel = .AFTFuel
      ofTotal = .TotalFuel
      onLightBitsSet = .LightBitsSet
      onLightBits2Set = .LightBits2Set
      onLightBits3Set = .LightBits3Set
      onVersionNum = .VersionNum
    End With
  End Select
  Exit Sub

FFDErr:
  MsgBox Err.Description & vbCr & "Generated by: FillFlightData" & vbCr & "Source: " & Err.Source & "(" & Err.Number & ")", vbOKOnly, "Falcon-A Error"
  Exit Sub
  
End Sub

Public Function Bearing(mnElement As Integer) As Single
' Bearing To Threat (Radians)
  Select Case gsFalconVersion                                      ' Determine Model to Use
  Case "OF"
    Bearing = ofOFBearing(mnElement)
  Case "BMS2"
    Bearing = ofBMSBearing(mnElement)
  Case "AF"
    Bearing = ofAFBearing(mnElement)
  End Select
End Function

Public Function MissileActivity(mnElement As Integer) As Single
' Missile is active or beam rider
  Select Case gsFalconVersion                                      ' Determine Model to Use
  Case "OF"
    MissileActivity = ofOFMissileActivity(mnElement)
  Case "BMS2"
    MissileActivity = ofBMSMissileActivity(mnElement)
  Case "AF"
    MissileActivity = ofAFMissileActivity(mnElement)
  End Select
  
End Function

Public Function MissileLaunch(mnElement As Integer) As Single
' Missile is launched
  Select Case gsFalconVersion                                      ' Determine Model to Use
  Case "OF"
    MissileLaunch = ofOFMissileLaunch(mnElement)
  Case "BMS2"
    MissileLaunch = ofBMSMissileLaunch(mnElement)
  Case "AF"
    MissileLaunch = ofAFMissileLaunch(mnElement)
  End Select
  
End Function
Public Function Selected(mnElement As Integer) As Single
' Threat is Selected
  Select Case gsFalconVersion                                      ' Determine Model to Use
  Case "OF"
    Selected = ofOFSelected(mnElement)
  Case "BMS2"
    Selected = ofBMSSelected(mnElement)
  Case "AF"
    Selected = ofAFSelected(mnElement)
  End Select
  
End Function
Public Function Lethality(mnElement As Integer) As Single
' Lethal Range
  Select Case gsFalconVersion                                      ' Determine Model to Use
  Case "OF"
      Lethality = ofOFLethality(mnElement)
  Case "BMS2"
      Lethality = ofBMSLethality(mnElement)
  Case "AF"
      Lethality = ofAFLethality(mnElement)
  End Select
  
End Function

