VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmF4Dat 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Falcon-A"
   ClientHeight    =   2070
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   9870
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "F4Dat.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2070
   ScaleWidth      =   9870
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame fraF4Dat 
      Caption         =   "Memory Model"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1470
      Index           =   1
      Left            =   7125
      TabIndex        =   6
      Top             =   105
      Width           =   2475
      Begin VB.OptionButton OptMemModel 
         Caption         =   "Falcon 4: Allied Force"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   240
         Index           =   1
         Left            =   105
         TabIndex        =   8
         Top             =   840
         Value           =   -1  'True
         Width           =   2220
      End
      Begin VB.OptionButton OptMemModel 
         Caption         =   "BMS 2.x"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   240
         Index           =   0
         Left            =   105
         TabIndex        =   7
         Top             =   465
         Width           =   2220
      End
   End
   Begin VB.Timer tmrF4Dat 
      Enabled         =   0   'False
      Index           =   1
      Interval        =   150
      Left            =   600
      Top             =   1605
   End
   Begin MSWinsockLib.Winsock FnASock 
      Index           =   0
      Left            =   120
      Top             =   1605
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Frame fraF4Dat 
      Caption         =   "Program Status"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1470
      Index           =   0
      Left            =   60
      TabIndex        =   1
      Top             =   105
      Width           =   6945
      Begin MSComctlLib.Slider sldF4Dat 
         Height          =   270
         Index           =   1
         Left            =   3810
         TabIndex        =   10
         Top             =   1110
         Width           =   1890
         _ExtentX        =   3334
         _ExtentY        =   476
         _Version        =   393216
         Min             =   1
         Max             =   500
         SelStart        =   250
         TickStyle       =   3
         Value           =   250
      End
      Begin MSComctlLib.Slider sldF4Dat 
         Height          =   270
         Index           =   0
         Left            =   3840
         TabIndex        =   9
         Top             =   420
         Width           =   1890
         _ExtentX        =   3334
         _ExtentY        =   476
         _Version        =   393216
         Min             =   1
         Max             =   500
         SelStart        =   250
         TickStyle       =   3
         Value           =   250
         TextPosition    =   1
      End
      Begin VB.CheckBox chkF4Dat 
         Caption         =   "Transmit TCP/IP"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   0
         Left            =   60
         TabIndex        =   3
         Top             =   1035
         Width           =   1815
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   330
         Index           =   4
         Left            =   5865
         TabIndex        =   12
         Top             =   1005
         Width           =   690
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   330
         Index           =   3
         Left            =   5865
         TabIndex        =   11
         Top             =   360
         Width           =   690
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   1  'Right Justify
         Caption         =   "TCP/IP Timer (ms):"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Index           =   2
         Left            =   1950
         TabIndex        =   5
         Top             =   1035
         Width           =   1845
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   1  'Right Justify
         Caption         =   "F4 Timer (ms):"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Index           =   1
         Left            =   1980
         TabIndex        =   4
         Top             =   405
         Width           =   1845
      End
      Begin VB.Label lblF4Dat 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Falcon Active"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H000000FF&
         Height          =   390
         Index           =   0
         Left            =   90
         TabIndex        =   2
         Top             =   315
         Width           =   1770
      End
   End
   Begin VB.Timer tmrF4Dat 
      Enabled         =   0   'False
      Index           =   0
      Interval        =   100
      Left            =   1095
      Top             =   1605
   End
   Begin VB.CommandButton cmdF4Dat 
      Caption         =   "E&xit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Index           =   0
      Left            =   8985
      TabIndex        =   0
      Top             =   1620
      Width           =   570
   End
End
Attribute VB_Name = "frmF4Dat"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'
'  ______            Falcon-A Shared Memory File Reader
'  L,.   ',          2004 - 2006 - Falcon-A Productions
'   \      ',_
'    \   @   ',
'     \ ^~^    ',
'      \    SC   ',
'       \___157FS  ',_                          _..----.._
'       [______       "'==.I\_____________..--"<__\\_n@___4\,_
'     ,..-=T         __   ____________          \/  "'" 0<==  "'-+.._
'     I____|_____    }_>=========I>=**""''==-------------==-   " |   "'-.,___
'   [_____,.--'"                             ""--=<""-----=====+==--''""
'     ""'-=+..,,__,-----,_____                  -=* |
'                 |__   /-----'#------.,I_---------'"
'                    """"'--..__         _.>
'                               ""'''''""

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Graphic Courtesy of Unknown artists via Angel
'
' Adapted from code by Erwin Neyt - Eagle 9 Systems
' Thanks to those @ ViperPit.Org who helped and for Jeff "Ref" Owen's Input
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  Option Explicit
 
  Dim glPSharedMem As Long                                         ' Shared memory
  Dim ghSharedMem                                                  ' Shared Memory Handle
  Dim mnErrorCounter As Integer                                    ' Error Counter
  Dim gbTCPIPConnect As Boolean                                    ' Connect via TCP/IP option
  Dim gsPacket(80) As String                                       ' TCP/IP Packet (80=all Instrument Array Elements Including LightBits & HSI Bits)
  Dim mbSocketInUse() As Boolean                                   ' Socket In Use Indicator
  
  Const sldFlightData = 0                                          ' Flight Data Timer Setting
  Const sldTCPIP = 1                                               ' TCP/IP Timer Setting
  Const tmrFlightData = 0                                          ' Flight Data Timer
  Const tmrTCPIP = 1                                               ' TCP/IP Timer
  
  Const cmdExit = 0                                                ' Exit Button
  Const fldFalconActive = 0
  Const chkTCPIP = 0                                               ' Enable/Disalbe TCP/IP
  
''  Const fldF4TimerValue = 0
''  Const fldTCPIPTimerValue = 1
  
  Const lblF4TimerValue = 3
  Const lblTCPIPTimerValue = 4
  
  ' Row Cross Reference for TCP/IP Packet Array NOTE:  This Array MUST Match the Cross Reference Array in Client Modules
  Const rowTCP_ShipNorth = 0                          ' Ownship North (Ft)
  Const rowTCP_ShipEast = 1                           ' Ownship East (Ft)
  Const rowTCP_ShipDown = 2                           ' Ownship Down (Ft)
  Const rowTCP_ShipNorthRate = 3                      ' Ownship North Rate (ft/sec)
  Const rowTCP_ShipEastRate = 4                       ' Ownship East Rate (ft/sec)
  Const rowTCP_ShipDownRate = 5                       ' Ownship Down Rate (ft/sec)
  Const rowTCP_Alpha = 6                              ' Ownship AOA (Degrees)
  Const rowTCP_Beta = 7                               ' Ownship Beta (Degrees)
  Const rowTCP_Gamma = 8                              ' Ownship Gamma (Radians)
  Const rowTCP_Pitch = 9                              ' Ownship Pitch (Radians)
  Const rowTCP_Roll = 10                              ' Ownship Roll (Radians)
  Const rowTCP_Yaw = 11                               ' Ownship Yaw (Radians)
  Const rowTCP_Mach = 12                              ' Ownship Mach number
  Const rowTCP_Kias = 13                              ' Ownship Indicated Airspeed (Knots)
  Const rowTCP_VT = 14                                ' Ownship True Airspeed (Ft/Sec)
  Const rowTCP_GS = 15                                ' Ownship Normal Gs
  Const rowTCP_WindOffset = 16                        ' Wind delta to FPM (Radians)
  Const rowTCP_NozzlePos = 17                         ' Ownship engine nozzle percent open (0-100)
  Const rowTCP_NozzlePos2 = 18                        ' Ownship engine nozzle2 percent open (0-100) - Multi-engine
  Const rowTCP_InternalFuel = 19                      ' Ownship internal fuel (Lbs)
  Const rowTCP_ExternalFuel = 20                      ' Ownship external fuel (Lbs)
  Const rowTCP_FuelFlow = 21                          ' Ownship fuel flow (Lbs/Hour)
  Const rowTCP_RPM = 22                               ' Ownship engine rpm (Percent 0-103)
  Const rowTCP_RPM2 = 23                              ' Ownship engine rpm2 (Percent 0-103) - multi-engine
  Const rowTCP_FTIT = 24                              ' Ownship Forward Turbine Inlet Temp (Degrees C)
  Const rowTCP_FTIT2 = 25                             ' Ownship Forward Turbine Inlet Temp2 (Degrees C)- multi-engine
  Const rowTCP_GearPos = 26                           ' Ownship Gear position 0 = up, 1 = down;
  Const rowTCP_SpeedBrake = 27                        ' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
  Const rowTCP_EPUFuel = 28                           ' Ownship EPU fuel (Percent 0-100)
  Const rowTCP_OilPressure = 29                       ' Ownship Oil Pressure (Percent 0-100)
  Const rowTCP_OilPressure2 = 30                      ' Ownship Oil Pressure2 (Percent 0-100)- Multi-engine
  Const rowTCP_LightBits = 31                         ' Cockpit Indicator Lights, one bit per bulb.
  Const rowTCP_HeadPitch = 32                         ' Head pitch offset from design eye (radians)
  Const rowTCP_HeadRoll = 33                          ' Head roll offset from design eye (radians)
  Const rowTCP_HeadYaw = 34                           ' Head yaw offset from design eye (radians)
  Const rowTCP_lightBits2 = 35                        ' Cockpit Indicator Lights, one bit per bulb. See enum
  Const rowTCP_lightBits3 = 36                        ' Cockpit Indicator Lights, one bit per bulb. See enum
  Const rowTCP_ChaffCount = 37                        ' Number of Chaff left
  Const rowTCP_FlareCount = 38                        ' Number of Flare left
  Const rowTCP_NoseGearPos = 39                       ' Position of the nose landinggear
  Const rowTCP_LeftGearPos = 40                       ' Position of the left landinggear
  Const rowTCP_RightGearPos = 41                      ' Position of the right landinggear
  Const rowTCP_AdiIlsHorPos = 42                      ' Position of horizontal ILS bar
  Const rowTCP_AdiIlsVerPos = 43                      ' Position of vertical ILS bar
  Const rowTCP_courseState = 44                       ' HSI_STA_CRS_STATE
  Const rowTCP_headingState = 45                      ' HSI_STA_HDG_STATE
  Const rowTCP_totalStates = 46                       ' HSI_STA_TOTAL_STATES ???
  Const rowTCP_courseDeviation = 47                   ' HSI_VAL_CRS_DEVIATION
  Const rowTCP_desiredCourse = 48                     ' HSI_VAL_DESIRED_CRS
  Const rowTCP_distanceToBeacon = 49                  ' HSI_VAL_DISTANCE_TO_BEACON
  Const rowTCP_bearingToBeacon = 50                   ' HSI_VAL_BEARING_TO_BEACON
  Const rowTCP_currentHeading = 51                    ' HSI_VAL_CURRENT_HEADING
  Const rowTCP_desiredHeading = 52                    ' HSI_VAL_DESIRED_HEADING
  Const rowTCP_deviationLimit = 53                    ' HSI_VAL_DEV_LIMIT
  Const rowTCP_halfDeviationLimit = 54                ' HSI_VAL_HALF_DEV_LIMIT
  Const rowTCP_localizerCourse = 55                   ' HSI_VAL_LOCALIZER_CRS
  Const rowTCP_airbaseX = 56                          ' HSI_VAL_AIRBASE_X
  Const rowTCP_airbaseY = 57                          ' HSI_VAL_AIRBASE_Y
  Const rowTCP_totalValues = 58                       ' HSI_VAL_TOTAL_VALUES  ???
  Const rowTCP_TrimPitch = 59                         ' Value of trim in pitch axis, -0.5 to +0.5
  Const rowTCP_TrimRoll = 60                          ' Value of trim in roll axis, -0.5 to +0.5
  Const rowTCP_TrimYaw = 61                           ' Value of trim in yaw axis, -0.5 to +0.5
  Const rowTCP_hsiBits = 62                           ' HSI flags
  Const rowTCP_DEDLines = 63                          ' DED 25 usable chars
  Const rowTCP_Invert = 64                            ' DED 25 usable chars
  Const rowTCP_PFLLines = 65                          ' PFL 25 usable chars
  Const rowTCP_PFLInvert = 66                         ' PFL 25 usable chars
  Const rowTCP_UFCTChan = 67                          ' UFC TACAN Channel
  Const rowTCP_AUXTChan = 68                          ' AUX TACAN Channel
  Const rowTCP_RWRObjectCount = 69                    ' Number of valid threat objects
  Const rowTCP_RWRSymbol = 70                         ' Type of Threat
  Const rowTCP_Bearing = 71                           ' Bearing of Threat
  Const rowTCP_MissileActivity = 72                   ' Missile is active or beam rider
  Const rowTCP_MissileLaunch = 73                     ' Missile is Launched
  Const rowTCP_Selected = 74                          ' Threat is Selected
  Const rowTCP_Lethality = 75                         ' Lethal Range
  Const rowTCP_FWD = 76                               ' Forward fuel tank Quantity
  Const rowTCP_AFT = 77                               ' Aft fuel tank quantity
  Const rowTCP_Total = 78                             ' Total fuel quantity
  Const rowTCP_LightBitsSet = 79                      ' LightBits Set (?)
  Const rowTCP_LightBits2Set = 80                     ' LightBits2 Set (?)
  Const rowTCP_LightBits3Set = 81                     ' LightBits3 Set (?)
  Const rowTCP_HSISet = 82                            ' HSI Set (?)
  Const rowTCP_VersionNum = 83                        ' Version of sh.mem file
  Const rowTCP_FalconActive = 84                      ' Is Falcon Active
  
  Const rowTCP_Max = 84                               ' Maximum TCP/IP Packet
  Dim mnMaxSocket As Integer                          ' Maximum # of TCP/IP Sockets
  
  Const optBMSMemModel = 0                            ' BMS Memory Model
  Const optAFMemModel = 1                             ' Allied Force Memory Model
  
Private Sub chkF4Dat_Click(Index As Integer)
' Check Box Click
  Dim mnCounter As Integer
  
  With chkF4Dat(Index)
    Select Case Index
    Case chkTCPIP                                                       ' TCP/IP Output Selected
      If chkF4Dat(chkTCPIP).Value = vbChecked Then
         FnASock(0).LocalPort = 1001                                    ' Port zero used for listening
         FnASock(0).Listen
         With Me
           For mnCounter = 1 To mnMaxSocket                             ' Setup mnMaxSocket # of Instances
             Load .FnASock(mnCounter)
           Next mnCounter
         End With
       Else
         For mnCounter = 0 To mnMaxSocket
           FnASock(mnCounter).Close
         Next mnCounter
       End If
      tmrF4Dat(tmrTCPIP).Enabled = chkF4Dat(chkTCPIP).Value = vbChecked ' Enable/Disable TCP/IP Timer
      sldF4Dat(sldTCPIP).Enabled = tmrF4Dat(tmrTCPIP).Enabled
    End Select
  End With
End Sub

Private Sub cmdF4Dat_Click(Index As Integer)
' Button Support
  Select Case Index
  Case cmdExit
    Unload Me
    End
  End Select

End Sub

Private Sub FnASock_ConnectionRequest(Index As Integer, ByVal requestID As Long)
  Dim mnCounter As Integer
  ' Accept the Connection for RequestID
  For mnCounter = 1 To mnMaxSocket
    ' Close connection if currently open
    If FnASock(mnCounter).State <> sckClosed Then
      FnASock(mnCounter).Close
      mbSocketInUse(mnCounter) = 0
    End If
    If mbSocketInUse(mnCounter) = 0 Then                      ' Socket Not In Use
      FnASock(mnCounter).Accept requestID
      mbSocketInUse(mnCounter) = 1
      GoTo ValidSocket
    End If
  Next mnCounter
  MsgBox "No Sockets Are Currently Available", vbOKOnly, "TCP/IP Socket Error"
  chkF4Dat(chkTCPIP).Value = vbUnchecked
  
ValidSocket:
  ' Bail
End Sub

Private Sub Form_Load()
  ' Startup Procedure
  Dim mnCounter As Integer
  
  On Error GoTo FLErr
  With App
    If .PrevInstance Then
      MsgBox "A Previous Instance of Falcon-A Server Is Running.  Please Press Ok", vbOKOnly, "Duplicate Execution"
      End
    End If
    Me.Caption = .FileDescription & " (v" & .Major & "." & .Minor & .Revision & ")"
  End With
  
  With Me
    .Left = Screen.Width - .Width - 100
    .Top = 500
  End With

  ' Chose the version you want to work with
  OptMemModel(optAFMemModel).Value = True
  
  gbFalconActive = False
  If OptMemModel(optBMSMemModel).Value = True Then
    gsFalconVersion = "BMS"
  ElseIf OptMemModel(optAFMemModel).Value = True Then
    gsFalconVersion = "AF"
  End If
  
  mnMaxSocket = 5                                                 ' Hard coded 5 socket maximum
  ReDim mbSocketInUse(mnMaxSocket)                                ' Set up array to track Sockets in use
  
  With lblF4Dat(fldFalconActive)
    .Caption = "Falcon Inactive"
    .ForeColor = &HFF&
  End With
  
  tmrF4Dat(tmrFlightData).Interval = sldF4Dat(sldFlightData).Value
  tmrF4Dat(tmrTCPIP).Interval = sldF4Dat(sldTCPIP).Value
  lblF4Dat(lblF4TimerValue).Caption = sldF4Dat(sldFlightData).Value
  lblF4Dat(lblTCPIPTimerValue).Caption = sldF4Dat(sldTCPIP).Value
  
  ' Setup TCP/IP
  'chkF4Dat(chkTCPIP).Value = vbChecked                             ' Hard-coded now, variable later
  gbTCPIPConnect = False                                           ' No Connection yet established
  
  DoEvents
  mnErrorCounter = 0
  gbFalconActive = False                                           ' Set Falcon Open Bit to False on Startup
  tmrF4Dat(tmrFlightData).Enabled = True
  tmrF4Dat(tmrTCPIP).Enabled = chkF4Dat(chkTCPIP).Value = vbChecked
  sldF4Dat(sldTCPIP).Enabled = tmrF4Dat(tmrTCPIP).Enabled
  Exit Sub
  
FLErr:
  MsgBox Err.Description & vbCr & "Generated by: " & Err.Source & "(" & Err.Number & ")" & vbCr & Err.HelpFile & vbCr & Err.HelpContext, vbOKOnly, "Falcon-A Error"
  YouAreTerminated

End Sub

Private Sub Form_Terminate()
  YouAreTerminated
End Sub

Private Sub Form_Unload(Cancel As Integer)
  YouAreTerminated
End Sub
Private Sub OpenF4SharedMemFile()
' Open the Falcon 4 Shared Memory File

  On Error GoTo OSMFErr
  
  ' Attempt to open F4 Shared Memory
  ghSharedMem = OpenFileMapping(FILE_MAP_READ, True, "FalconSharedMemoryArea")
  
  If ghSharedMem > 0 Then                                         ' Successful Open - Handle Obtained
    glPSharedMem = MapViewOfFile(ghSharedMem, FILE_MAP_READ, 0, 0, 0)
    gbFalconActive = True
  Else                                                            ' Unable to open the shared memory file
    'UnmapViewOfFile (glPSharedMem)
    CloseHandle (ghSharedMem)
    gbFalconActive = False
  End If
  
  ' Set Falcon Active Indicator
  With lblF4Dat(fldFalconActive)
    .Caption = IIf(gbFalconActive, "Falcon-A", "Falcon Inactive")
    .ForeColor = IIf(gbFalconActive, &HFF00&, &HFF&)
    .FontBold = gbFalconActive
  End With
  DoEvents
  Exit Sub
  
OSMFErr:
  MsgBox Err.Description & vbCr & "Generated by: " & Err.Source & "(" & Err.Number & ")" & vbCr & Err.HelpFile & vbCr & Err.HelpContext, vbOKOnly, "Falcon-A Error"
  YouAreTerminated
  

End Sub
Private Sub BlowItOutYourTCPIPPort(mnSocket As Integer)
' Format Data an Transmit via TCP/IP Port
' Parameters:  mnSocket   - TCP/IP Socket Number
  
  Dim mnCounter As Integer
  Dim mvPacket As Variant
  
  On Error GoTo FFDErr

  With FDBMS
    gsPacket(rowTCP_ShipNorth) = "@" & CStr(.ShipNorth)
    gsPacket(rowTCP_ShipEast) = "@" & CStr(.ShipEast)
    gsPacket(rowTCP_ShipDown) = "@" & CStr(.ShipDown)
    gsPacket(rowTCP_ShipNorthRate) = "@" & CStr(.ShipNorthRate)
    gsPacket(rowTCP_ShipEastRate) = "@" & CStr(.ShipEastRate)
    gsPacket(rowTCP_ShipDownRate) = "@" & CStr(.ShipDownRate)
    gsPacket(rowTCP_Alpha) = "@" & CStr(.Alpha)
    gsPacket(rowTCP_Beta) = "@" & CStr(.Beta)
    gsPacket(rowTCP_Gamma) = "@" & CStr(.Gamma)
    gsPacket(rowTCP_Pitch) = "@" & CStr(.Pitch)
    gsPacket(rowTCP_Roll) = "@" & CStr(.Roll)
    gsPacket(rowTCP_Yaw) = "@" & CStr(.Yaw)
    gsPacket(rowTCP_Mach) = "@" & CStr(.Mach)
    gsPacket(rowTCP_Kias) = "@" & CStr(.KIAS)
    gsPacket(rowTCP_VT) = "@" & CStr(.VT)
    gsPacket(rowTCP_GS) = "@" & CStr(.GS)
    gsPacket(rowTCP_WindOffset) = "@" & CStr(.WindOffset)
    gsPacket(rowTCP_NozzlePos) = "@" & CStr(.NozzlePos)
    gsPacket(rowTCP_NozzlePos2) = "@" & CStr(.NozzlePos2)
    gsPacket(rowTCP_InternalFuel) = "@" & (.InternalFuel)
    gsPacket(rowTCP_ExternalFuel) = "@" & CStr(.ExternalFuel)
    gsPacket(rowTCP_FuelFlow) = "@" & CStr(.FuelFlow)
    gsPacket(rowTCP_RPM) = "@" & CStr(.RPM)
    gsPacket(rowTCP_RPM2) = "@" & CStr(.RPM2)
    gsPacket(rowTCP_FTIT) = "@" & CStr(.FTIT)
    gsPacket(rowTCP_FTIT2) = "@" & CStr(.FTIT2)
    gsPacket(rowTCP_GearPos) = "@" & CStr(.GearPos)
    gsPacket(rowTCP_SpeedBrake) = "@" & CStr(.SpeedBrake)
    gsPacket(rowTCP_EPUFuel) = "@" & CStr(.EPUFuel)
    gsPacket(rowTCP_OilPressure) = "@" & CStr(.OilPressure)
    gsPacket(rowTCP_OilPressure2) = "@" & CStr(.OilPressure2)
    gsPacket(rowTCP_LightBits) = "@" & CStr(.LightBits)
    gsPacket(rowTCP_HeadPitch) = "@" & CStr(.HeadPitch)
    gsPacket(rowTCP_HeadRoll) = "@" & CStr(.HeadRoll)
    gsPacket(rowTCP_HeadYaw) = "@" & CStr(.HeadYaw)
    gsPacket(rowTCP_lightBits2) = "@" & CStr(.LightBits2)
    gsPacket(rowTCP_lightBits3) = "@" & CStr(.LightBits3)
    gsPacket(rowTCP_ChaffCount) = "@" & CStr(.ChaffCount)
    gsPacket(rowTCP_FlareCount) = "@" & CStr(.FlareCount)
    gsPacket(rowTCP_NoseGearPos) = "@" & CStr(.NoseGearPos)
    gsPacket(rowTCP_LeftGearPos) = "@" & CStr(.LeftGearPos)
    gsPacket(rowTCP_RightGearPos) = "@" & CStr(.RightGearPos)
    gsPacket(rowTCP_AdiIlsHorPos) = "@" & CStr(.AdiIlsHorPos)
    gsPacket(rowTCP_AdiIlsVerPos) = "@" & CStr(.AdiIlsVerPos)
    gsPacket(rowTCP_courseState) = "@" & CStr(.CourseState)
    gsPacket(rowTCP_headingState) = "@" & CStr(.HeadingState)
    gsPacket(rowTCP_totalStates) = "@" & CStr(.TotalStates)
    gsPacket(rowTCP_courseDeviation) = "@" & CStr(.CourseDeviation)
    gsPacket(rowTCP_desiredCourse) = "@" & CStr(.DesiredCourse)
    gsPacket(rowTCP_distanceToBeacon) = "@" & CStr(.DistanceToBeacon)
    gsPacket(rowTCP_bearingToBeacon) = "@" & CStr(.BearingToBeacon)
    gsPacket(rowTCP_currentHeading) = "@" & CStr(.CurrentHeading)
    gsPacket(rowTCP_desiredHeading) = "@" & CStr(.DesiredHeading)
    gsPacket(rowTCP_deviationLimit) = "@" & CStr(.DeviationLimit)
    gsPacket(rowTCP_halfDeviationLimit) = "@" & CStr(.HalfDeviationLimit)
    gsPacket(rowTCP_localizerCourse) = "@" & CStr(.LocalizerCourse)
    gsPacket(rowTCP_airbaseX) = "@" & CStr(.AirBaseX)
    gsPacket(rowTCP_airbaseY) = "@" & CStr(.AirBaseY)
    gsPacket(rowTCP_totalValues) = "@" & CStr(.TotalValues)
    gsPacket(rowTCP_TrimPitch) = "@" & CStr(.TrimPitch)
    gsPacket(rowTCP_TrimRoll) = "@" & CStr(.TrimRoll)
    gsPacket(rowTCP_TrimYaw) = "@" & CStr(.TrimYaw)
    gsPacket(rowTCP_hsiBits) = "@" & CStr(.HSIBits)
    gsPacket(rowTCP_DEDLines) = "@" & CStr(.DEDLines)
    gsPacket(rowTCP_Invert) = "@" & CStr(.Invert)
    gsPacket(rowTCP_PFLLines) = "@" & CStr(.PFLLines)
    gsPacket(rowTCP_PFLInvert) = "@" & CStr(.PFLInvert)
    gsPacket(rowTCP_UFCTChan) = "@" & CStr(.UFCTChan)
    gsPacket(rowTCP_AUXTChan) = "@" & CStr(.AUXTChan)
    gsPacket(rowTCP_RWRObjectCount) = "@" & CStr(.RWRObjectCount)
    ' Build Array Data for Bearing, MissileActivity, MissileLaunch, Selected, Lethality (all arrays same size - 20)
    gsPacket(rowTCP_RWRSymbol) = "@"
    gsPacket(rowTCP_Bearing) = "@"
    gsPacket(rowTCP_MissileActivity) = "@"
    gsPacket(rowTCP_MissileLaunch) = "@"
    gsPacket(rowTCP_Selected) = "@"
    gsPacket(rowTCP_Lethality) = "@"
    For mnCounter = 0 To 19                           ' Hard Coded for 20 array elements
      gsPacket(rowTCP_RWRSymbol) = gsPacket(rowTCP_RWRSymbol) & CStr(.RWRSymbol(mnCounter)) & IIf(mnCounter = 19, "", "/")
      gsPacket(rowTCP_Bearing) = gsPacket(rowTCP_Bearing) & CStr(.Bearing(mnCounter)) & IIf(mnCounter = 19, "", "/")
      gsPacket(rowTCP_MissileActivity) = gsPacket(rowTCP_MissileActivity) & CStr(.MissileActivity(1)) & IIf(mnCounter = 19, "", "/")
      gsPacket(rowTCP_MissileLaunch) = gsPacket(rowTCP_MissileLaunch) & CStr(.MissileLaunch(1)) & IIf(mnCounter = 19, "", "/")
      gsPacket(rowTCP_Selected) = gsPacket(rowTCP_Selected) & CStr(.Selected(1)) & IIf(mnCounter = 19, "", "/")
      gsPacket(rowTCP_Lethality) = gsPacket(rowTCP_Lethality) & CStr(.Lethality(1)) & IIf(mnCounter = 19, "", "/")
    Next mnCounter
    gsPacket(rowTCP_FWD) = "@" & CStr(.FWDFuel)
    gsPacket(rowTCP_AFT) = "@" & CStr(.AFTFuel)
    gsPacket(rowTCP_Total) = "@" & CStr(.TotalFuel)
    gsPacket(rowTCP_LightBitsSet) = "@" & CStr(.LightBitsSet)
    gsPacket(rowTCP_LightBits2Set) = "@" & CStr(.LightBits2Set)
    gsPacket(rowTCP_LightBits3Set) = "@" & CStr(.LightBits3Set)
    gsPacket(rowTCP_HSISet) = "@" & CStr(.HSISet)
    gsPacket(rowTCP_VersionNum) = "@" & CStr(.VersionNum)
  End With
  gsPacket(rowTCP_FalconActive) = "@" & CStr(Abs(CInt(gbFalconActive)))
  
  mvPacket = gsPacket(rowTCP_ShipNorth) & gsPacket(rowTCP_ShipEast) & gsPacket(rowTCP_ShipDown) & gsPacket(rowTCP_ShipNorthRate) & _
      gsPacket(rowTCP_ShipEastRate) & gsPacket(rowTCP_ShipDownRate) & gsPacket(rowTCP_Alpha) & gsPacket(rowTCP_Beta) & gsPacket(rowTCP_Gamma) & _
      gsPacket(rowTCP_Pitch) & gsPacket(rowTCP_Roll) & gsPacket(rowTCP_Yaw) & gsPacket(rowTCP_Mach) & gsPacket(rowTCP_Kias) & _
      gsPacket(rowTCP_VT) & gsPacket(rowTCP_GS) & gsPacket(rowTCP_WindOffset) & gsPacket(rowTCP_NozzlePos) & gsPacket(rowTCP_NozzlePos2) & _
      gsPacket(rowTCP_InternalFuel) & gsPacket(rowTCP_ExternalFuel) & gsPacket(rowTCP_FuelFlow) & gsPacket(rowTCP_RPM) & gsPacket(rowTCP_RPM2) & _
      gsPacket(rowTCP_FTIT) & gsPacket(rowTCP_FTIT2) & gsPacket(rowTCP_GearPos) & gsPacket(rowTCP_SpeedBrake) & gsPacket(rowTCP_EPUFuel) & _
      gsPacket(rowTCP_OilPressure) & gsPacket(rowTCP_OilPressure2) & gsPacket(rowTCP_LightBits) & gsPacket(rowTCP_HeadPitch) & gsPacket(rowTCP_HeadRoll) & _
      gsPacket(rowTCP_HeadYaw) & gsPacket(rowTCP_lightBits2) & gsPacket(rowTCP_lightBits3) & gsPacket(rowTCP_ChaffCount) & gsPacket(rowTCP_FlareCount) & _
      gsPacket(rowTCP_NoseGearPos) & gsPacket(rowTCP_LeftGearPos) & gsPacket(rowTCP_RightGearPos) & gsPacket(rowTCP_AdiIlsHorPos) & gsPacket(rowTCP_AdiIlsVerPos) & _
      gsPacket(rowTCP_courseState) & gsPacket(rowTCP_headingState) & gsPacket(rowTCP_totalStates) & gsPacket(rowTCP_courseDeviation) & gsPacket(rowTCP_desiredCourse) & _
      gsPacket(rowTCP_distanceToBeacon) & gsPacket(rowTCP_bearingToBeacon) & gsPacket(rowTCP_currentHeading) & gsPacket(rowTCP_desiredHeading) & gsPacket(rowTCP_deviationLimit) & _
      gsPacket(rowTCP_halfDeviationLimit) & gsPacket(rowTCP_localizerCourse) & gsPacket(rowTCP_airbaseX) & gsPacket(rowTCP_airbaseY) & gsPacket(rowTCP_totalValues) & _
      gsPacket(rowTCP_TrimPitch) & gsPacket(rowTCP_TrimRoll) & gsPacket(rowTCP_TrimYaw) & gsPacket(rowTCP_hsiBits) & gsPacket(rowTCP_DEDLines) & gsPacket(rowTCP_Invert) & _
      gsPacket(rowTCP_PFLLines) & gsPacket(rowTCP_PFLInvert) & gsPacket(rowTCP_UFCTChan) & gsPacket(rowTCP_AUXTChan) & gsPacket(rowTCP_RWRObjectCount) & _
      gsPacket(rowTCP_RWRSymbol) & gsPacket(rowTCP_Bearing) & gsPacket(rowTCP_MissileActivity) & gsPacket(rowTCP_MissileLaunch) & gsPacket(rowTCP_Selected) & _
      gsPacket(rowTCP_Lethality) & gsPacket(rowTCP_FWD) & gsPacket(rowTCP_AFT) & gsPacket(rowTCP_Total) & _
      gsPacket(rowTCP_LightBitsSet) & gsPacket(rowTCP_LightBits2Set) & gsPacket(rowTCP_LightBits3Set) & gsPacket(rowTCP_HSISet) & gsPacket(rowTCP_VersionNum) & gsPacket(rowTCP_FalconActive)
  
  ' Send data to client Ports
  FnASock(mnSocket).SendData mvPacket
  DoEvents
  Exit Sub
  
FFDErr:
  MsgBox Err.Description & vbCr & "Generated by: BlowItOutYourTCPIPPort" & vbCr & "Source: " & Err.Source & "(" & Err.Number & ")", vbOKOnly, "Falcon-A Error"
  Exit Sub
  
End Sub

Private Sub YouAreTerminated()
  Dim mnCounter As Integer
  On Error Resume Next
  tmrF4Dat(tmrFlightData).Enabled = False
  tmrF4Dat(tmrTCPIP).Enabled = False
  UnmapViewOfFile (glPSharedMem)
  CloseHandle (ghSharedMem)                                        ' Close Shared Memory File
  For mnCounter = 0 To mnMaxSocket
    FnASock(mnCounter).Close
  Next mnCounter
  End
End Sub

Private Sub OptMemModel_Click(Index As Integer)
' Set appropriate Shared Memory Model
  If OptMemModel(optBMSMemModel).Value = True Then
    gsFalconVersion = "BMS"
  ElseIf OptMemModel(optAFMemModel).Value = True Then
    gsFalconVersion = "AF"
  End If
  
End Sub

Private Sub sldF4Dat_Click(Index As Integer)

  With sldF4Dat(Index)
    Select Case Index
    Case sldFlightData
      tmrF4Dat(tmrFlightData).Interval = .Value
      lblF4Dat(lblF4TimerValue).Caption = .Value
    Case sldTCPIP
      tmrF4Dat(tmrTCPIP).Interval = .Value
      lblF4Dat(lblTCPIPTimerValue).Caption = .Value
    End Select
  End With
  
End Sub

Private Sub tmrF4Dat_Timer(Index As Integer)
  ' Process Timer Events
  Dim mnCounter As Integer
  
  On Error GoTo F4DatError
  
  If Not gbFalconActive Then                                       ' Check for F4
    OpenF4SharedMemFile                                            ' Attempt to open Memory file
    Exit Sub
  End If
  
  Select Case Index
  Case tmrFlightData
    If OptMemModel(optBMSMemModel).Value = True Then               ' BMS Memory Model
      CopyMemory FDBMS, ByVal glPSharedMem, Len(FDBMS)             ' Copy Shared Memory to BMS Flight Data
    ElseIf OptMemModel(optAFMemModel).Value = True Then            ' Allied Force Memory Model
      CopyMemory FDAF, ByVal glPSharedMem, Len(FDAF)               ' Copy Shared Memory to AF Flight Data
    End If
  Case tmrTCPIP
    For mnCounter = 1 To mnMaxSocket
      If FnASock(mnCounter).State = sckConnected Then              ' If a connection exists
        BlowItOutYourTCPIPPort mnCounter                           ' Blast Out TCP/IP Data
      Else
        FnASock(mnCounter).Close
      End If
    Next mnCounter
  End Select
  
  DoEvents
  Exit Sub
  
F4DatError:
  mnErrorCounter = mnErrorCounter + 1
  MsgBox "Error: " & Err.Description & vbCr & "Has Occurred In Falcon-A", vbOKOnly, "Falcon-A Error Message"
  If mnErrorCounter = 5 Then YouAreTerminated

End Sub
