Attribute VB_Name = "F4Lib"
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Falcin' Ay Visual Basic Common Library
'
' 2004 - 2006 - Falcon-A Productions
'
' Adapted from code by Erwin Neyt - Eagle 9 Systems
' Thanks to those @ ViperPit.Org who helped and for Jeff "Ref" Owen's Input
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  Option Explicit
  
  Public Const SECTION_MAP_WRITE = &H2&
  Public Const SECTION_MAP_READ = &H4&
  Public Const FILE_MAP_WRITE = SECTION_MAP_WRITE
  Public Const FILE_MAP_READ = SECTION_MAP_READ

 
  Declare Function OpenFileMapping Lib "kernel32" Alias "OpenFileMappingA" (ByVal dwDesiredAccess As Long, ByVal bInheritHandle As Long, ByVal lpName As String) As Long
  Declare Function MapViewOfFile Lib "kernel32" (ByVal hFileMappingObject As Long, ByVal dwDesiredAccess As Long, ByVal dwFileOffsetHigh As Long, ByVal dwFileOffsetLow As Long, ByVal dwNumberOfBytesToMap As Long) As Long
  Declare Function UnmapViewOfFile Lib "kernel32" (lpBaseAddress As Any) As Long
  Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
  Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal numbytes As Long)
  Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
  
  ' Various Memory Model Types
  Global FDBMS As BMSFlightData             ' BMS 2.x Flight Data
  Global FDAF As AFFlightData               ' Allied Force Flight Data
  
  Global gbFalconActive As Boolean          ' Falcon 4 Active Variable
  Global gsFalconVersion As String          ' Falcon Version (BMS & AF)
  
  
''' Flight Data Memory Models (BMS & AF)
  ' BMS 2.x Flight Data Model
  Public Type BMSFlightData
    ShipNorth As Single                     ' Position of aircraft in North-South direction
    ShipEast As Single                      ' Position of aircraft in East-West direction
    ShipDown As Single                      ' Elevation of Aircraft
    ShipNorthRate As Single                 ' Velocity of Aircraft in North-South direction(ft/sec)
    ShipEastRate As Single                  ' Velocity of Aircraft in East-West direction (ft/sec)
    ShipDownRate As Single                  ' Rate of Descent/Climb
    Alpha As Single                         ' Ownship Angle of Attack (Degrees)
    Beta As Single                          ' Ownship Beta (Degrees)
    Gamma As Single                         ' Ownship Gamma (Radians)
    Pitch As Single                         ' Ownship Pitch Angle (Radians)
    Roll As Single                          ' Ownship Roll Angle (Radians)
    Yaw As Single                           ' Ownship Yaw Angle (Radians) (can also be used as magnetic heading)
    Mach As Single                          ' Ownship Mach number (Mach)
    KIAS As Single                          ' Ownship Indicated Airspeed (Knots)
    VT As Single                            ' Ownship True Airspeed (Ft/Sec)
    GS As Single                            ' Ownship G-Force (Gs)
    WindOffset As Single                    ' Wind delta to FPM (Radians)
    NozzlePos As Single                     ' Ownship engine nozzle percent open (0-100)
    NozzlePos2 As Single                    ' Ownship engine nozzle2 percent open (0-100) - Multi-engine
    InternalFuel As Single                  ' Ownship internal fuel (Lbs)
    ExternalFuel As Single                  ' Ownship external fuel (Lbs)
    FuelFlow As Single                      ' Ownship fuel flow (Lbs/Hour)
    RPM As Single                           ' Ownship engine rpm (Percent 0-103)
    RPM2 As Single                          ' Ownship engine rpm2 (Percent 0-103) - multi-engine
    FTIT As Single                          ' Ownship Forward Turbine Inlet Temp (Degrees C)
    FTIT2 As Single                         ' Ownship Forward Turbine Inlet Temp2 (Degrees C) - multi-engine
    GearPos As Single                       ' Ownship Gear position 0 = up, 1 = down;
    SpeedBrake As Single                    ' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
    EPUFuel As Single                       ' Ownship EPU fuel (Percent 0-100)
    OilPressure As Single                   ' Ownship Oil Pressure (Percent 0-100)
    OilPressure2 As Single                  ' Ownship Oil Pressure2 (Percent 0-100)- Multi-engine
    LightBits As Long                       ' Cockpit Indicator Lights, one bit per bulb. See enum
    HeadPitch As Single                     ' Head pitch offset from design eye (radians)
    HeadRoll As Single                      ' Head roll offset from design eye (radians)
    HeadYaw As Single                       ' Head yaw offset from design eye (radians)
    LightBits2 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    LightBits3 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    ChaffCount As Single                    ' Number of Chaff left
    FlareCount As Single                    ' Number of Flare left
    NoseGearPos As Single                   ' Position of the nose landinggear
    LeftGearPos As Single                   ' Position of the left landinggear
    RightGearPos As Single                  ' Position of the right landinggear
    AdiIlsHorPos As Single                  ' Position of horizontal ILS bar
    AdiIlsVerPos As Single                  ' Position of vertical ILS bar
    CourseState As Long                     ' HSI_STA_CRS_STATE
    HeadingState As Long                    ' HSI_STA_HDG_STATE
    TotalStates As Long                     ' HSI_STA_TOTAL_STATES ???
    CourseDeviation  As Single              ' HSI_VAL_CRS_DEVIATION
    DesiredCourse As Single                 ' HSI_VAL_DESIRED_CRS
    DistanceToBeacon As Single              ' HSI_VAL_DISTANCE_TO_BEACON
    BearingToBeacon As Single               ' HSI_VAL_BEARING_TO_BEACON
    CurrentHeading As Single                ' HSI_VAL_CURRENT_HEADING
    DesiredHeading  As Single               ' HSI_VAL_DESIRED_HEADING
    DeviationLimit As Single                ' HSI_VAL_DEV_LIMIT
    HalfDeviationLimit As Single            ' HSI_VAL_HALF_DEV_LIMIT
    LocalizerCourse As Single               ' HSI_VAL_LOCALIZER_CRS
    AirBaseX As Single                      ' HSI_VAL_AIRBASE_X
    AirBaseY As Single                      ' HSI_VAL_AIRBASE_Y
    TotalValues As Single                   ' HSI_VAL_TOTAL_VALUES  ???
    TrimPitch As Single                     ' Value of trim in pitch axis, -0.5 to +0.5
    TrimRoll As Single                      ' Value of trim in roll axis, -0.5 to +0.5
    TrimYaw As Single                       ' Value of trim in yaw axis, -0.5 to +0.5
    HSIBits As Long                         ' HSI flags
    DEDLines As String * 130                ' DED 6 * 26 usable chars
    Invert As String * 130                  ' DED 6 * 26 usable chars
    PFLLines As String * 130                ' PFL 6 * 26 usable chars
    PFLInvert As String * 130               ' PFL 6 * 26 usable chars
    UFCTChan As Long                        ' UFC TACAN Channel
    AUXTChan  As Long                       ' AUX TACAN Channel
    RWRObjectCount  As Long                 ' Number of valid threat objects
    RWRSymbol(20) As Long                   ' Type of threat
    Bearing(20) As Single                   ' Bearing to threat (radians)
    MissileActivity(20) As Single           ' Missile is active or beam rider
    MissileLaunch(20) As Single             ' Missile is launched
    Selected(20) As Single                  ' Threat is Selected
    Lethality(20) As Single                 ' Lethal Range
    FWDFuel As Single                       ' Forward Fuel Tank Quantity
    AFTFuel As Single                       ' Aft Fuel Tank Quantity
    TotalFuel As Single                     ' Total Fuel Tank Quantity
    LightBitsSet As Long                    ' Light Bits Set
    LightBits2Set As Long                   ' Light Bits 2 Set
    LightBits3Set As Long                   ' Light Bits 3 Set
    HSISet As Long                          ' HSI Set
    VersionNum As Long                      ' Version of sh.mem file
  End Type
  
  
  ' Allied Force Flight Data Model
  Public Type AFFlightData
    ShipNorth As Single                     ' Position of aircraft in North-South direction
    ShipEast As Single                      ' Position of aircraft in East-West direction
    ShipDown As Single                      ' Elevation of Aircraft
    ShipNorthRate As Single                 ' Velocity of Aircraft in North-South direction(ft/sec)
    ShipEastRate As Single                  ' Velocity of Aircraft in East-West direction (ft/sec)
    ShipDownRate As Single                  ' Rate of Descent/Climb
    Alpha As Single                         ' Ownship Angle of Attack (Degrees)
    Beta As Single                          ' Ownship Beta (Degrees)
    Gamma As Single                         ' Ownship Gamma (Radians)
    Pitch As Single                         ' Ownship Pitch Angle (Radians)
    Roll As Single                          ' Ownship Roll Angle (Radians)
    Yaw As Single                           ' Ownship Yaw Angle (Radians) (can also be used as magnetic heading)
    Mach As Single                          ' Ownship Mach number (Mach)
    KIAS As Single                          ' Ownship Indicated Airspeed (Knots)
    VT As Single                            ' Ownship True Airspeed (Ft/Sec)
    GS As Single                            ' Ownship G-Force (Gs)
    WindOffset As Single                    ' Wind delta to FPM (Radians)
    NozzlePos As Single                     ' Ownship engine nozzle percent open (0-100)
    InternalFuel As Single                  ' Ownship internal fuel (Lbs)
    ExternalFuel As Single                  ' Ownship external fuel (Lbs)
    FuelFlow As Single                      ' Ownship fuel flow (Lbs/Hour)
    RPM As Single                           ' Ownship engine rpm (Percent 0-103)
    FTIT As Single                          ' Ownship Forward Turbine Inlet Temp (Degrees C)
    GearPos As Single                       ' Ownship Gear position 0 = up, 1 = down;
    SpeedBrake As Single                    ' Ownship speed brake position 0 = closed, 1 = 60 Degrees open
    EPUFuel As Single                       ' Ownship EPU fuel (Percent 0-100)
    OilPressure As Single                   ' Ownship Oil Pressure (Percent 0-100)
    LightBits As Long                       ' Cockpit Indicator Lights, one bit per bulb. See enum
    HeadPitch As Single                     ' Head pitch offset from design eye (radians)
    HeadRoll As Single                      ' Head roll offset from design eye (radians)
    HeadYaw As Single                       ' Head yaw offset from design eye (radians)
    LightBits2 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    LightBits3 As Long                      ' Cockpit Indicator Lights, one bit per bulb. See enum
    ChaffCount As Single                    ' Number of Chaff left
    FlareCount As Single                    ' Number of Flare left
    NoseGearPos As Single                   ' Position of the nose landinggear
    LeftGearPos As Single                   ' Position of the left landinggear
    RightGearPos As Single                  ' Position of the right landinggear
    AdiIlsHorPos As Single                  ' Position of horizontal ILS bar
    AdiIlsVerPos As Single                  ' Position of vertical ILS bar
    CourseState As Long                     ' HSI_STA_CRS_STATE
    HeadingState As Long                    ' HSI_STA_HDG_STATE
    TotalStates As Long                     ' HSI_STA_TOTAL_STATES ???
    CourseDeviation  As Single              ' HSI_VAL_CRS_DEVIATION
    DesiredCourse As Single                 ' HSI_VAL_DESIRED_CRS
    DistanceToBeacon As Single              ' HSI_VAL_DISTANCE_TO_BEACON
    BearingToBeacon As Single               ' HSI_VAL_BEARING_TO_BEACON
    CurrentHeading As Single                ' HSI_VAL_CURRENT_HEADING
    DesiredHeading  As Single               ' HSI_VAL_DESIRED_HEADING
    DeviationLimit As Single                ' HSI_VAL_DEV_LIMIT
    HalfDeviationLimit As Single            ' HSI_VAL_HALF_DEV_LIMIT
    LocalizerCourse As Single               ' HSI_VAL_LOCALIZER_CRS
    AirBaseX As Single                      ' HSI_VAL_AIRBASE_X
    AirBaseY As Single                      ' HSI_VAL_AIRBASE_Y
    TotalValues As Single                   ' HSI_VAL_TOTAL_VALUES  ???
    TrimPitch As Single                     ' Value of trim in pitch axis, -0.5 to +0.5
    TrimRoll As Single                      ' Value of trim in roll axis, -0.5 to +0.5
    TrimYaw As Single                       ' Value of trim in yaw axis, -0.5 to +0.5
    HSIBits As Long                         ' HSI flags
    DEDLines As String * 130                ' DED 6 * 26 usable chars
    Invert As String * 130                  ' DED 6 * 26 usable chars
    PFLLines As String * 130                ' PFL 6 * 26 usable chars
    PFLInvert As String * 130               ' PFL 6 * 26 usable chars
    UFCTChan As Long                        ' UFC TACAN Channel
    AUXTChan  As Long                       ' AUX TACAN Channel
    RWRObjectCount  As Long                 ' Number of valid threat objects
    RWRSymbol(40) As Long                   ' Type of threat
    Bearing(40) As Single                   ' Bearing to threat (radians)
    MissileActivity(40) As Single           ' Missile is active or beam rider
    MissileLaunch(40) As Single             ' Missile is launched
    Selected(40) As Single                  ' Threat is Selected
    Lethality(40) As Single                 ' Lethal Range
    NewDetection(40) As Single              ' New Detection
    FWDFuel As Single                       ' Forward Fuel Tank Quantity
    AFTFuel As Single                       ' Aft Fuel Tank Quantity
    TotalFuel As Single                     ' Total Fuel Tank Quantity
    LightBitsSet As Long                    ' Light Bits Set
    LightBits2Set As Long                   ' Light Bits 2 Set
    LightBits3Set As Long                   ' Light Bits 3 Set
    HSISet As Long                          ' HSI Set
    VersionNum As Long                      ' Version of sh.mem file
  End Type


Public Sub Main()
  frmF4Dat.Show
End Sub

