VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsLampData"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Falcon 4/BMS 2.0 Shared Memory File Reader
'
' 2004 - Sherksoft Canada Inc.
'
' Adapted from code by Erwin Neyt - Eagle 9 Systems
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'       Class: clsLampData
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Description: Falcon BMS 2.0 Shared Memory Lamp Data
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

    Option Explicit
    
    ' LightBits
    Dim obMasterCaution As Boolean                     ' Master Caution
    ' Brow Lights
    Dim obTF As Boolean                                ' Terrain Following Radar Active
    Dim obOBS As Boolean                               ' Not implemented and not used
    Dim obALT As Boolean                               ' Altitude - Below ALOW
    Dim obWOW As Boolean                               ' Weight On Wheels (not a lamp bit)
    Dim obENG_FIRE As Boolean                          ' Engine Fire Lamp
    Dim obCONFIG As Boolean                            ' Stores Config Caution Panel Indicator
    Dim obHYD As Boolean                               ' Hydraulic failure lamp
    Dim obOIL As Boolean                               ' Oil pressure fault lamp (RPM<40 or Enigne Fault)
    Dim obDUAL As Boolean                              ' FCC Fault.  No aparenet lamp in blcok 50/52
    Dim obCAN As Boolean                               ' Canopy Failure
    Dim obT_L_CFG As Boolean                           ' Takeoff/Landing Configuration Warning
    
    ' AOA Indexers
    Dim obAOAAbove As Boolean                          ' AOA - Above Glide Slope
    Dim obAOAOn As Boolean                             ' AOA - On Glide Slope
    Dim obAOABelow As Boolean                          ' AOA - Below Glide Slope

    ' Refuel/NWS
    Dim obRefuelRDY As Boolean                         ' Refuel - Ready
    Dim obRefuelAR As Boolean                          ' Air Refueling / Nose Wheel Steering
    Dim obRefuelDSC As Boolean                         ' Refuel - Disconnect

    ' Caution Lights
    Dim obFltControlSys As Boolean                     ' FLCS Fault
    Dim obLEFlaps As Boolean                           ' LFE Flaps indicator (only set under complete electrical failure)
    Dim obEngineFault As Boolean                       ' Engine Fault
    Dim obOverheat As Boolean                          ' Engine Overheat
    Dim obFuelLow As Boolean                           ' Fuel Low
    Dim obAvionics As Boolean                          ' Avionics Fault
    Dim obRadarAlt As Boolean                          ' Radar Altimeter Fault
    Dim obIFF As Boolean                               ' IFF Fault
    Dim obECM As Boolean                               ' Electronic Counter Measures Fault
    Dim obHook As Boolean                              ' Hook Fault
    Dim obNWSFail As Boolean                           ' Nose Wheel Steering Failure
    Dim obCabinPress As Boolean                        ' Cabin Pressure
    Dim obAutoPilotOn As Boolean                       ' MD -- 20031125: is AP on??  NB: This is not a lamp bit!
    Dim obTFR_STBY As Boolean                          ' Terrain Following Radar - Standby Mode

    ' MD 20031016: Use this with the MAL/IND light code in cautions.cpp
    ' please update this is you add/change bits!
    Dim obAllLampBitsOn As Boolean               ' All Lamps on

    ' LightBits2
    ' Threat Warning Prime
    Dim obHandOff As Boolean                     ' Handoff
    Dim obLaunch  As Boolean                     ' Missile Launch Indicator
    Dim obPriMode As Boolean                     ' Priority Mode
    Dim obNaval  As Boolean                      ' Naval Target - Increase Priority
    Dim obUnk  As Boolean                        ' Unknown Radar Source Detected
    Dim obTgtSep  As Boolean                     ' Target Separation

    ' Threat Warning Aux
    Dim obAuxSrch  As Boolean                    ' Display Search Radar
    Dim obAuxAct  As Boolean                     ' Radar Activity Detected
    Dim obAuxLow  As Boolean                     ' Prioritize Low Altitude Targets
    Dim obAuxPwr  As Boolean                     ' RWR System Power

    ' ECM
    Dim obEcmPwr  As Boolean                     ' ECM System Power
    Dim obEcmFail  As Boolean                    ' ECM Failure

    ' Caution Lights
    Dim obFwdFuelLow  As Boolean                 ' Forward Fuel Tank Low
    Dim obAftFuelLow  As Boolean                 ' Aft Fuel Tank Low

    ' Engine lights
    Dim obEPUOn  As Boolean                      ' EPU On
    Dim obJFSOn  As Boolean                      ' JFS On
    Dim obSEC  As Boolean                        ' Secondary Engine control (RPM <20%)

    Dim obOXY_LOW  As Boolean                    ' Oxygen Low
    Dim obPROBEHEAT  As Boolean                  ' Probe Heat
    Dim obSEAT_ARM  As Boolean                   ' Seat Arm
    Dim obBUC  As Boolean                        ' Not implemented
    Dim obFUEL_OIL_HOT  As Boolean               ' Fuel Oil Hot
    Dim obANTI_SKID  As Boolean                  ' Anti Skid
    Dim obTFR_ENGAGED  As Boolean                ' LANTIRN mode TFR Active
    Dim obGEARHANDLE  As Boolean                 ' Gear Handle Lamp
    Dim obENGINE  As Boolean                     ' lower half of glareshield ENG FIRE/ENGINE lamp

     ' MD 20031016: Use this with the MAL/IND light code in cautions.cpp
     ' please update this is you add/change bits!
    Dim obAllLampBits2On  As Boolean
    
    ' LightBits3
    Dim obFlcsPmg  As Boolean                     ' Flight Control System
    Dim obMainGen  As Boolean                     ' Main Generator
    Dim obStbyGen  As Boolean                     ' Stdby Generator
    Dim obEpuGen  As Boolean                      ' EPU Generator
    Dim obEpuPmg  As Boolean                      ' EPU Power
    Dim obToFlcs  As Boolean                      ' To Flight Control System
    Dim obFlcsRly  As Boolean                     ' Flight Control System Relay
    Dim obBatFail  As Boolean                     ' Battery Failure
    Dim obHydrazine  As Boolean                   ' Hydrazine Fault
    Dim obAir  As Boolean                         ' Airflow Fault
    Dim obElec_Fault  As Boolean                  ' Electronics Fault
    Dim obLef_Fault  As Boolean                   ' Leading Edge Flap Damage
    Dim obPower_Off  As Boolean                   ' Set if there is no electrical power
    Dim obEng2_Fire  As Boolean                   ' TJL 01/24/04 Multi-engine
    Dim obLockLight  As Boolean                   ' TJL 01/24/04 Lock Light Cue
    Dim obShoot  As Boolean                       ' TJL 01/24/04 Shoot light cue
    Dim obNoseGearDown  As Boolean                ' MD -- 20040301: on means down and locked
    Dim obLeftGearDown  As Boolean                ' MD -- 20040301: on means down and locked
    Dim obRightGearDown  As Boolean               ' MD -- 20040301: on means down and locked

    ' MD 20031016: Use this with the MAL/IND light code in cautions.cpp
    ' please update this is you add/change bits!
    Dim obAllLampBits3On  As Boolean
    
    ' HSI Bits
    Dim obToTrue As Boolean                       ' HSI_FLAG_TO_TRUE
    Dim obIlsWarning As Boolean                   ' HSI_FLAG_ILS_WARN
    Dim obCourseWarning As Boolean                ' HSI_FLAG_CRS_WARN
    Dim obInit As Boolean                         ' HSI_FLAG_INIT
    Dim obTotalFlags As Boolean                   ' HSI_FLAG_TOTAL_FLAGS ???
    Dim obADI_OFF As Boolean                      ' ADI OFF Flag
    Dim obADI_AUX As Boolean                      ' ADI AUX Flag
    Dim obADI_GS As Boolean                       ' ADI GS FLAG
    Dim obADI_LOC As Boolean                      ' ADI LOC FLAG
    Dim obHSI_OFF As Boolean                      ' HSI OFF Flag
    Dim obBUP_ADI_OFF As Boolean                  ' Backup ADI Off Flag
    Dim obVVI As Boolean                          ' VVI OFF Flag
    Dim obAOA As Boolean                          ' AOA OFF Flag
    Dim obAVTR As Boolean                         ' AVTR Light
    ' MD 20031016: Use this with the MAL/IND light code in cautions.cpp
    ' please update this is you add/change bits!
    Dim obAllLampHsiBitsOn As Boolean

' ** LightBits **
' Brow Lights
Public Property Let MasterCaution(vbBool As Boolean)
' Master Caution
  obMasterCaution = vbBool
End Property
Public Property Get MasterCaution() As Boolean
' Master Caution
  MasterCaution = obMasterCaution
End Property
Public Property Let TF(vbBool As Boolean)
' Terrain Following Radar Active
  obTF = vbBool
End Property
Public Property Get TF() As Boolean
' Terrain Following Radar Active
  TF = obTF
End Property
Public Property Let OBS(vbBool As Boolean)
' Not Used
  obOBS = vbBool
End Property
Public Property Get OBS() As Boolean
' Not Used
  OBS = obOBS
End Property
Public Property Let ALT(vbBool As Boolean)
' Altitude - Below ALOW
  obALT = vbBool
End Property
Public Property Get ALT() As Boolean
' Altitude - Below ALOW
  ALT = obALT
End Property
Public Property Let WOW(vbBool As Boolean)
' Weight On Wheels (not a lamp bit)
  obWOW = vbBool
End Property
Public Property Get WOW() As Boolean
' Weight On Wheels (not a lamp bit)
  WOW = obWOW
End Property
Public Property Let ENG_FIRE(vbBool As Boolean)
' Engine Fire Lamp
  obENG_FIRE = vbBool
End Property
Public Property Get ENG_FIRE() As Boolean
' Engine Fire Lamp
  ENG_FIRE = obENG_FIRE
End Property
Public Property Let CONFIG(vbBool As Boolean)
' Stores Config Caution Panel Indicator
  obCONFIG = vbBool
End Property
Public Property Get CONFIG() As Boolean
' Stores Config Caution Panel Indicator
  CONFIG = obCONFIG
End Property
Public Property Let HYD(vbBool As Boolean)
' Hydraulic failure lamp
  obHYD = vbBool
End Property
Public Property Get HYD() As Boolean
' Hydraulic failure lamp
  HYD = obHYD
End Property
Public Property Let OIL(vbBool As Boolean)
' Oil pressure fault lamp (RPM<40 or Enigne Fault)
  obOIL = vbBool
End Property
Public Property Get OIL() As Boolean
' Oil pressure fault lamp (RPM<40 or Enigne Fault)
  OIL = obOIL
End Property
Public Property Let DUAL(vbBool As Boolean)
' FCC Fault.  No aparenet lamp in blcok 50/52
  obDUAL = vbBool
End Property
Public Property Get DUAL() As Boolean
' FCC Fault.  No aparenet lamp in blcok 50/52
  DUAL = obDUAL
End Property
Public Property Let CAN(vbBool As Boolean)
' Canopy Failure
  obCAN = vbBool
End Property
Public Property Get CAN() As Boolean
' Canopy Failure
  CAN = obCAN
End Property
Public Property Let T_L_CFG(vbBool As Boolean)
' Takeoff/Landing Configuration Warning
  obT_L_CFG = vbBool
End Property
Public Property Get T_L_CFG() As Boolean
' Takeoff/Landing Configuration Warning
  T_L_CFG = obT_L_CFG
End Property

' AOA Indexers
Public Property Let AOAAbove(vbBool As Boolean)
' AOA - Above Glide Slope
  obAOAAbove = vbBool
End Property
Public Property Get AOAAbove() As Boolean
' AOA - Above Glide Slope
  AOAAbove = obAOAAbove
End Property
Public Property Let AOAOn(vbBool As Boolean)
' AOA - On Glide Slope
  obAOAOn = vbBool
End Property
Public Property Get AOAOn() As Boolean
' AOA - On Glide Slope
  AOAOn = obAOAOn
End Property
Public Property Let AOABelow(vbBool As Boolean)
' AOA - Below Glide Slope
  obAOABelow = vbBool
End Property
Public Property Get AOABelow() As Boolean
' AOA - Below Glide Slope
  AOABelow = obAOABelow
End Property

' Refuel/NWS
Public Property Let RefuelRDY(vbBool As Boolean)
' Refuel - Ready
  obRefuelRDY = vbBool
End Property
Public Property Get RefuelRDY() As Boolean
' Refuel - Ready
  RefuelRDY = obRefuelRDY
End Property
Public Property Let RefuelAR(vbBool As Boolean)
' Air Refueling / Nose Wheel Steering
  obRefuelAR = vbBool
End Property
Public Property Get RefuelAR() As Boolean
' Air Refueling / Nose Wheel Steering
  RefuelAR = obRefuelAR
End Property
Public Property Let RefuelDSC(vbBool As Boolean)
' Refuel - Disconnect
  obRefuelDSC = vbBool
End Property
Public Property Get RefuelDSC() As Boolean
' Refuel - Disconnect
  RefuelDSC = obRefuelDSC
End Property

' Caution Lights
Public Property Let FltControlSys(vbBool As Boolean)
' FLCS Fault
  obFltControlSys = vbBool
End Property
Public Property Get FltControlSys() As Boolean
' FLCS Fault
  FltControlSys = obFltControlSys
End Property
Public Property Let LEFlaps(vbBool As Boolean)
' LFE Flaps indicator (only set under complete electrical failure)
  obLEFlaps = vbBool
End Property
Public Property Get LEFlaps() As Boolean
' LFE Flaps indicator (only set under complete electrical failure)
  LEFlaps = obLEFlaps
End Property
Public Property Let EngineFault(vbBool As Boolean)
' Engine Fault
  obEngineFault = vbBool
End Property
Public Property Get EngineFault() As Boolean
' Engine Fault
  EngineFault = obEngineFault
End Property
Public Property Let Overheat(vbBool As Boolean)
' Engine Overheat
  obOverheat = vbBool
End Property
Public Property Get Overheat() As Boolean
' Engine Overheat
  Overheat = obOverheat
End Property
Public Property Let FuelLow(vbBool As Boolean)
' Engine Fuel Low
  obFuelLow = vbBool
End Property
Public Property Get FuelLow() As Boolean
' Engine Fuel Low
  FuelLow = obFuelLow
End Property
Public Property Let Avionics(vbBool As Boolean)
' Avionics Fault
  obAvionics = vbBool
End Property
Public Property Get Avionics() As Boolean
' Avionics Fault
  Avionics = obAvionics
End Property
Public Property Let RadarAlt(vbBool As Boolean)
' Radar Altimeter
  obRadarAlt = vbBool
End Property
Public Property Get RadarAlt() As Boolean
' Radar Altimeter
  RadarAlt = obRadarAlt
End Property

Public Property Let IFF(vbBool As Boolean)
' IFF Fault
  obIFF = vbBool
End Property
Public Property Get IFF() As Boolean
' IFF Fault
  IFF = obIFF
End Property
Public Property Let ECM(vbBool As Boolean)
' ECM Fault
  obECM = vbBool
End Property
Public Property Get ECM() As Boolean
' ECM Fault
  ECM = obECM
End Property
Public Property Let Hook(vbBool As Boolean)
' Hook Fault
  obHook = vbBool
End Property
Public Property Get Hook() As Boolean
' Hook Fault
  Hook = obHook
End Property
Public Property Let NWSFail(vbBool As Boolean)
' Nose Wheel Steering Failure
  obNWSFail = vbBool
End Property
Public Property Get NWSFail() As Boolean
' Nose Wheel Steering Failure
  NWSFail = obNWSFail
End Property
Public Property Let CabinPress(vbBool As Boolean)
' Cabin Pressure Fault
  obCabinPress = vbBool
End Property
Public Property Get CabinPress() As Boolean
' Cabin Pressure Fault
  CabinPress = obCabinPress
End Property
Public Property Let AutoPilotOn(vbBool As Boolean)
' AutoPilot On (not a lamp bit)
  obAutoPilotOn = vbBool
End Property
Public Property Get AutoPilotOn() As Boolean
' AutoPilot On (not a lamp bit)
  AutoPilotOn = obAutoPilotOn
End Property
Public Property Let TFR_STBY(vbBool As Boolean)
' Terrain Following Radar - Standby Mode
  obTFR_STBY = vbBool
End Property
Public Property Get TFR_STBY() As Boolean
' Terrain Following Radar - Standby Mode
  TFR_STBY = obTFR_STBY
End Property
Public Property Let AllLampBitsOn(vbBool As Boolean)
' All Lamp Bits On
  obAllLampBitsOn = vbBool
End Property
Public Property Get AllLampBitsOn() As Boolean
' All Lamp Bits On
  AllLampBitsOn = obAllLampBitsOn
End Property

' ** LightBits2 **
' Threat Warning Prime
Public Property Let HandOff(vbBool As Boolean)
' TWP - HandOff
  obHandOff = vbBool
End Property
Public Property Get HandOff() As Boolean
' TWP - HandOff
  HandOff = obHandOff
End Property
Public Property Let Launch(vbBool As Boolean)
' TWP - Missile Launch Indicator
  obLaunch = vbBool
End Property
Public Property Get Launch() As Boolean
' TWP - Missile Launch Indicator
  Launch = obLaunch
End Property
Public Property Let PriMode(vbBool As Boolean)
' TWP - Primary Mode
  obPriMode = vbBool
End Property
Public Property Get PriMode() As Boolean
' TWP - Primary Mode
  PriMode = obPriMode
End Property
Public Property Let Naval(vbBool As Boolean)
' TWP - Naval Priority
  obNaval = vbBool
End Property
Public Property Get Naval() As Boolean
' TWP - Naval Priority
  Naval = obNaval
End Property
Public Property Let Unk(vbBool As Boolean)
' TWP - Unknown Radar Source Detected
  obUnk = vbBool
End Property
Public Property Get Unk() As Boolean
' TWP - Unknown Radar Source Detected
  Unk = obUnk
End Property
Public Property Let TgtSep(vbBool As Boolean)
' TWP - Target Separation
  obTgtSep = vbBool
End Property
Public Property Get TgtSep() As Boolean
' TWP - Target Separation
  TgtSep = obTgtSep
End Property

' Threat Warning Aux
Public Property Let AuxSrch(vbBool As Boolean)
' TWA - Display Search Radar
  obAuxSrch = vbBool
End Property
Public Property Get AuxSrch() As Boolean
' TWA - Display Search Radar
  AuxSrch = obAuxSrch
End Property
Public Property Let AuxAct(vbBool As Boolean)
' TWA - Radar Activity Detected
  obAuxAct = vbBool
End Property
Public Property Get AuxAct() As Boolean
' TWA - Radar Activity Detected
  AuxAct = obAuxAct
End Property
Public Property Let AuxLow(vbBool As Boolean)
' TWA - Prioritize Low Altitude Targets
  obAuxLow = vbBool
End Property
Public Property Get AuxLow() As Boolean
' TWA - Prioritize Low Altitude Targets
  AuxLow = obAuxLow
End Property
Public Property Let AuxPwr(vbBool As Boolean)
' TWA - RWR System Power
  obAuxPwr = vbBool
End Property
Public Property Get AuxPwr() As Boolean
' TWA - RWR System Power
  AuxPwr = obAuxPwr
End Property

' ECM
Public Property Let ECMPwr(vbBool As Boolean)
' ECM System Power
  obEcmPwr = vbBool
End Property
Public Property Get ECMPwr() As Boolean
' ECM System Power
  ECMPwr = obEcmPwr
End Property
Public Property Let ECMFail(vbBool As Boolean)
' ECM System Failure
  obEcmFail = vbBool
End Property
Public Property Get ECMFail() As Boolean
' ECM System Failure
  ECMFail = obEcmFail
End Property

' Caution Lights
Public Property Let FwdFuelLow(vbBool As Boolean)
' Forward Fuel Tank Low
  obFwdFuelLow = vbBool
End Property
Public Property Get FwdFuelLow() As Boolean
' Forward Fuel Tank Low
  FwdFuelLow = obFwdFuelLow
End Property
Public Property Let AftFuelLow(vbBool As Boolean)
' Aft Fuel Tank Low
  obAftFuelLow = vbBool
End Property
Public Property Get AftFuelLow() As Boolean
' Aft Fuel Tank Low
  AftFuelLow = obAftFuelLow
End Property

' Engine lights
Public Property Let EPUOn(vbBool As Boolean)
' EPU On
  obEPUOn = vbBool
End Property
Public Property Get EPUOn() As Boolean
' EPU On
  EPUOn = obEPUOn
End Property
Public Property Let JFSOn(vbBool As Boolean)
' JFS On
  obJFSOn = vbBool
End Property
Public Property Get JFSOn() As Boolean
' JFS On
  JFSOn = obJFSOn
End Property
Public Property Let SEC(vbBool As Boolean)
' Secondary Engine control (RPM <20%)
  obSEC = vbBool
End Property
Public Property Get SEC() As Boolean
' Secondary Engine control (RPM <20%)
  SEC = obSEC
End Property
Public Property Let Oxy_Low(vbBool As Boolean)
' Oxygen Low
  obOXY_LOW = vbBool
End Property
Public Property Get Oxy_Low() As Boolean
' Oxygen Low
  Oxy_Low = obOXY_LOW
End Property
Public Property Let ProbeHeat(vbBool As Boolean)
' Probe Heat
  obPROBEHEAT = vbBool
End Property
Public Property Get ProbeHeat() As Boolean
' Probe Heat
  ProbeHeat = obPROBEHEAT
End Property
Public Property Let Seat_Arm(vbBool As Boolean)
' Seat_Arm
  obSEAT_ARM = vbBool
End Property
Public Property Get Seat_Arm() As Boolean
' Seat_Arm
  Seat_Arm = obSEAT_ARM
End Property
Public Property Let BUC(vbBool As Boolean)
' Not Used
  obBUC = vbBool
End Property
Public Property Get BUC() As Boolean
' Not Used
  BUC = obBUC
End Property
Public Property Let Fuel_Oil_Hot(vbBool As Boolean)
' Fuel Oil Hot
  obFUEL_OIL_HOT = vbBool
End Property
Public Property Get Fuel_Oil_Hot() As Boolean
' Fuel Oil Hot
  Fuel_Oil_Hot = obFUEL_OIL_HOT
End Property
Public Property Let Anti_Skid(vbBool As Boolean)
' Anti_Skid
  obANTI_SKID = vbBool
End Property
Public Property Get Anti_Skid() As Boolean
' Anti_Skid
  Anti_Skid = obANTI_SKID
End Property
Public Property Let TFR_Engaged(vbBool As Boolean)
' LANTIRN Mode TFR Engaged
  obTFR_ENGAGED = vbBool
End Property
Public Property Get TFR_Engaged() As Boolean
' LANTIRN Mode TFR Engaged
  TFR_Engaged = obTFR_ENGAGED
End Property
Public Property Let GearHandle(vbBool As Boolean)
' Gear Handle
  obGEARHANDLE = vbBool
End Property
Public Property Get GearHandle() As Boolean
' Gear Handle
  GearHandle = obGEARHANDLE
End Property
Public Property Let Engine(vbBool As Boolean)
' Lower half of glareshield ENG FIRE/ENGINE lamp
  obENGINE = vbBool
End Property
Public Property Get Engine() As Boolean
' Lower half of glareshield ENG FIRE/ENGINE lamp
  Engine = obENGINE
End Property
Public Property Let AllLampBits2On(vbBool As Boolean)
' All Lamp Bits(2) On
  obAllLampBits2On = vbBool
End Property
Public Property Get AllLampBits2On() As Boolean
' All Lamp Bits(2) On
  AllLampBits2On = obAllLampBits2On
End Property

' ** Lightbits 3 **
Public Property Let FlcsPmg(vbBool As Boolean)
' Flight Control System
  obFlcsPmg = vbBool
End Property
Public Property Get FlcsPmg() As Boolean
' Flight Control System
  FlcsPmg = obFlcsPmg
End Property
Public Property Let MainGen(vbBool As Boolean)
' Main Generator
  obMainGen = vbBool
End Property
Public Property Get MainGen() As Boolean
' Main Generator
  MainGen = obMainGen
End Property
Public Property Let StbyGen(vbBool As Boolean)
' Stby Generator
  obStbyGen = vbBool
End Property
Public Property Get StbyGen() As Boolean
' Stby Generator
  StbyGen = obStbyGen
End Property
Public Property Let EPUGen(vbBool As Boolean)
' EPU Generator
  obEpuGen = vbBool
End Property
Public Property Get EPUGen() As Boolean
' EPU Generator
  EPUGen = obEpuGen
End Property
Public Property Let EPUPmg(vbBool As Boolean)
' EPU Power
  obEpuPmg = vbBool
End Property
Public Property Get EPUPmg() As Boolean
' EPU Power
  EPUPmg = obEpuPmg
End Property
Public Property Let ToFlcs(vbBool As Boolean)
' To Flight Control System
  obToFlcs = vbBool
End Property
Public Property Get ToFlcs() As Boolean
' To Flight Control System
  ToFlcs = obToFlcs
End Property
Public Property Let FlcsRly(vbBool As Boolean)
' Flight Control System Relay
  obFlcsRly = vbBool
End Property
Public Property Get FlcsRly() As Boolean
' Flight Control System Relay
  FlcsRly = obFlcsRly
End Property
Public Property Let BatFail(vbBool As Boolean)
' Battery Failure
  obBatFail = vbBool
End Property
Public Property Get BatFail() As Boolean
' Battery Failure
  BatFail = obBatFail
End Property
Public Property Let Hydrazine(vbBool As Boolean)
' Hydrazine Fault
  obHydrazine = vbBool
End Property
Public Property Get Hydrazine() As Boolean
' Hydrazine Fault
  Hydrazine = obHydrazine
End Property
Public Property Let Air(vbBool As Boolean)
' Airflow Fault
  obAir = vbBool
End Property
Public Property Get Air() As Boolean
' Airflow Fault
  Air = obAir
End Property
Public Property Let Elec_Fault(vbBool As Boolean)
' Electronics Fault
  obElec_Fault = vbBool
End Property
Public Property Get Elec_Fault() As Boolean
' Electronics Fault
  Elec_Fault = obElec_Fault
End Property
Public Property Let LEF_Fault(vbBool As Boolean)
' Leading Edge Flap Fault
  obLef_Fault = vbBool
End Property
Public Property Get LEF_Fault() As Boolean
' Leading Edge Flap Fault
  LEF_Fault = obLef_Fault
End Property
Public Property Let Power_Off(vbBool As Boolean)
' Set if there is no electrical power
  obPower_Off = vbBool
End Property
Public Property Get Power_Off() As Boolean
' Set if there is no electrical power
  Power_Off = obPower_Off
End Property
Public Property Let Eng2_Fire(vbBool As Boolean)
' Engine 2 Fire
  obEng2_Fire = vbBool
End Property
Public Property Get Eng2_Fire() As Boolean
' Engine 2 Fire
  Eng2_Fire = obEng2_Fire
End Property
Public Property Let LockLight(vbBool As Boolean)
' Lock Light Cue
  obLockLight = vbBool
End Property
Public Property Get LockLight() As Boolean
' Lock Light Cue
  LockLight = obLockLight
End Property
Public Property Let Shoot(vbBool As Boolean)
' Shoot Light Cue
  obShoot = vbBool
End Property
Public Property Get Shoot() As Boolean
' Shoot Light Cue
  Shoot = obShoot
End Property
Public Property Let NoseGearDown(vbBool As Boolean)
' Nose Gear Down
  obNoseGearDown = vbBool
End Property
Public Property Get NoseGearDown() As Boolean
' Nose Gear Down
  NoseGearDown = obNoseGearDown
End Property
Public Property Let LeftGearDown(vbBool As Boolean)
' Left Gear Down
  obLeftGearDown = vbBool
End Property
Public Property Get LeftGearDown() As Boolean
' Left Gear Down
  LeftGearDown = obLeftGearDown
End Property
Public Property Let RightGearDown(vbBool As Boolean)
' Right Gear Down
  obRightGearDown = vbBool
End Property
Public Property Get RightGearDown() As Boolean
' Right Gear Down
  RightGearDown = obRightGearDown
End Property
Public Property Let AllLampBits3On(vbBool As Boolean)
' All Lamp Bits(3) On
  obAllLampBits3On = vbBool
End Property
Public Property Get AllLampBits3On() As Boolean
' All Lamp Bits(3) On
  AllLampBits3On = obAllLampBits3On
End Property

'HSI Bits
Public Property Let ToTrue(vbBool As Boolean)
' HSI_FLAG_TO_TRUE
  obToTrue = vbBool
End Property
Public Property Get ToTrue() As Boolean
' HSI_FLAG_TO_TRUE
  ToTrue = obToTrue
End Property
Public Property Let ILSWarning(vbBool As Boolean)
' ILS Warning - HSI_FLAG_ILS_WARN
  obIlsWarning = vbBool
End Property
Public Property Get ILSWarning() As Boolean
' ILS Warning - HSI_FLAG_ILS_WARN
  ILSWarning = obIlsWarning
End Property
Public Property Let CourseWarning(vbBool As Boolean)
' Course Warning - HSI_FLAG_CRS_WARN
  obCourseWarning = vbBool
End Property
Public Property Get CourseWarning() As Boolean
' Course Warning - HSI_FLAG_CRS_WARN
  CourseWarning = obCourseWarning
End Property
Public Property Let Init(vbBool As Boolean)
' HSI_FLAG_INIT
  obInit = vbBool
End Property
Public Property Get Init() As Boolean
' HSI_FLAG_INIT
  Init = obInit
End Property
Public Property Let TotalFlags(vbBool As Boolean)
' HSI_FLAG_TOTAL_FLAGS ???
  obTotalFlags = vbBool
End Property
Public Property Get TotalFlags() As Boolean
' HSI_FLAG_TOTAL_FLAGS ???
  TotalFlags = obTotalFlags
End Property
Public Property Let ADI_Off(vbBool As Boolean)
' ADI Off Flag
  obADI_OFF = vbBool
End Property
Public Property Get ADI_Off() As Boolean
' ADI Off Flag
  ADI_Off = obADI_OFF
End Property
Public Property Let ADI_Aux(vbBool As Boolean)
' ADI Aux Flag
  obADI_AUX = vbBool
End Property
Public Property Get ADI_Aux() As Boolean
' ADI Aux Flag
  ADI_Aux = obADI_AUX
End Property
Public Property Let ADI_GS(vbBool As Boolean)
' ADI GS Flag
  obADI_GS = vbBool
End Property
Public Property Get ADI_GS() As Boolean
' ADI GS Flag
  ADI_GS = obADI_GS
End Property
Public Property Let ADI_LOC(vbBool As Boolean)
' ADI LOC Flag
  obADI_LOC = vbBool
End Property
Public Property Get ADI_LOC() As Boolean
' ADI LOC Flag
  ADI_LOC = obADI_LOC
End Property
Public Property Let HSI_OFF(vbBool As Boolean)
' HSI OFF Flag
  obHSI_OFF = vbBool
End Property
Public Property Get HSI_OFF() As Boolean
' HSI OFF Flag
  HSI_OFF = obHSI_OFF
End Property
Public Property Let BUP_ADI_OFF(vbBool As Boolean)
' Backup ADI Off Flag
  obBUP_ADI_OFF = vbBool
End Property
Public Property Get BUP_ADI_OFF() As Boolean
' Backup ADI Off Flag
  BUP_ADI_OFF = obBUP_ADI_OFF
End Property
Public Property Let VVI(vbBool As Boolean)
' VVI OFF Flag
  obVVI = vbBool
End Property
Public Property Get VVI() As Boolean
' VVI OFF Flag
  VVI = obVVI
End Property
Public Property Let AOA(vbBool As Boolean)
' AOA OFF Flag
  obAOA = vbBool
End Property
Public Property Get AOA() As Boolean
' AOA OFF Flag
  AOA = obAOA
End Property
Public Property Let AVTR(vbBool As Boolean)
' AVTR Light
  obAVTR = vbBool
End Property
Public Property Get AVTR() As Boolean
' AVTR Light
  AVTR = obAVTR
End Property
Public Property Let AllLampHsiBitsOn(vbBool As Boolean)
' obAllLampHsiBitsOn
  obAllLampHsiBitsOn = vbBool
End Property
Public Property Get AllLampHsiBitsOn() As Boolean
' obAllLampHsiBitsOn
  AllLampHsiBitsOn = obAllLampHsiBitsOn
End Property








'Public Property Let OBS(vbBool As Boolean)
'' OBS
'  obOBS = vbBool
'End Property
'Public Property Get OBS() As Boolean
'' OBS
'  OBS = obOBS
'End Property


