using System;
using System.Collections.Generic;
using System.Text;
using F4SharedMem;
using System.Runtime.InteropServices;
using System.Reflection;
namespace SharedMemoryTester
{
    class Program
    {
        static void Main(string[] args)
        {
            string falconType = "alliedforce";
            if (args != null && args.Length >0)
            {
                falconType = args[0];
            }
            FalconDataFormats format = FalconDataFormats.AlliedForce;
            if (falconType != null)
            {
                if (falconType.ToLowerInvariant().Equals("bms") ||
                    falconType.ToLowerInvariant().Equals("bms2") || 
                    falconType.ToLowerInvariant().Equals("redviper") ||
                    falconType.ToLowerInvariant().Equals("freefalcon")
                    )
                {
                    format = FalconDataFormats.BMS2;
                }
                else if (falconType.ToLowerInvariant().Equals("of") ||
                    falconType.ToLowerInvariant().Equals("openfalcon")
                    )
                {
                    format = FalconDataFormats.OpenFalcon;
                }
                else if (falconType.ToLowerInvariant().Equals("af") ||
               falconType.ToLowerInvariant().Equals("alliedforce")
               )
                {
                    format = FalconDataFormats.AlliedForce;
                }
            }
            using (Reader reader = new Reader(format))
            {
                Console.WriteLine("Connecting to Falcon using the " + Enum.GetName(typeof(FalconDataFormats), format) + " data format...");
                while (!reader.IsFalconRunning)
                {
                    System.Threading.Thread.Sleep(1000);
                    Console.Write(".");
                }
                Console.WriteLine();
                Console.WriteLine("--START OF REPORT--");
                FlightData flightdata = reader.GetCurrentData();
                Type dataType = flightdata.GetType();
                FieldInfo[] fields = dataType.GetFields(BindingFlags.Public | BindingFlags.Instance);
                for (int i = 0; i < fields.Length; i++)
                {
                    FieldInfo currentField = fields[i];
                    Type currentFieldType = currentField.FieldType;
                    if (currentFieldType.IsArray)
                    {
                        System.Array currentValue = (System.Array)currentField.GetValue(flightdata);
                        if (currentValue != null)
                        {
                            int j = 0;
                            foreach (object currentItem in currentValue)
                            {
                                if (currentItem != null)
                                {
                                    if (currentItem.GetType() == typeof(FlightData.OnScreenButtonLabel))
                                    {
                                        FlightData.OnScreenButtonLabel thisLabel = (FlightData.OnScreenButtonLabel)currentItem;
                                        Console.WriteLine(currentField.Name + "[" + j + "]:Line1:" + thisLabel.Line1);
                                        Console.WriteLine(currentField.Name + "[" + j + "]:Line2:" + thisLabel.Line2);
                                        Console.WriteLine(currentField.Name + "[" + j + "]:Inverted:" + thisLabel.Inverted);
                                    }
                                    else
                                    {
                                        Console.WriteLine(currentField.Name + "[" + j + "]:" + currentItem.ToString());
                                    }
                                }
                                else
                                {
                                    Console.WriteLine(currentField.Name + "[" + j + "]:null");
                                }
                                j++;
                            }
                        }
                        else
                        {
                            Console.WriteLine(currentField.Name + "[]:null");
                        }
                    }
                    else
                    {
                        object value = currentField.GetValue(flightdata);
                        if (value == null)
                        {
                            Console.WriteLine(currentField.Name + ":null");
                        }
                        else
                        {
                            if (currentField.Name.ToLowerInvariant().Contains("bits"))
                            {
                                Console.Write(currentField.Name + ":");
                                Console.Write("(" + value + "):");
                                System.Collections.BitArray bits = new System.Collections.BitArray(new int[]{(int)(uint)value});
                                for (int k=bits.Length-1;k>=0;k--) {
                                    bool bit = bits[k];
                                    if (bit){
                                        Console.Write("1");
                                    }
                                    else {
                                        Console.Write("0");
                                    }
                                }
                                Console.Write("    {");
                                if (currentField.Name.ToLowerInvariant().Equals("lightbits"))
                                {
                                    Console.Write(Enum.Parse(typeof(F4SharedMem.LightBits),""+value).ToString());
                                }
                                else if (currentField.Name.ToLowerInvariant().Equals("lightbits2"))
                                {
                                    Console.Write(Enum.Parse(typeof(F4SharedMem.LightBits2), "" +value).ToString());
                                }
                                else if (currentField.Name.ToLowerInvariant().Equals("lightbits3"))
                                {
                                    Console.Write(Enum.Parse(typeof(F4SharedMem.LightBits3), "" + value).ToString());
                                }
                                else if (currentField.Name.ToLowerInvariant().Equals("hsibits"))
                                {
                                    Console.Write(Enum.Parse(typeof(F4SharedMem.HsiBits), "" + value).ToString());
                                }
                                Console.Write("}");

                                Console.WriteLine();
                            }
                            else
                            {
                                Console.WriteLine(currentField.Name + ":" + value.ToString());
                            }
                        }
                    }
                }

            }
            Console.WriteLine("--END OF REPORT--");
        }
    }
}
